/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.collectd;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.collectd.MetaData;
import com.codahale.metrics.collectd.PacketWriter;
import com.codahale.metrics.collectd.Sanitize;
import com.codahale.metrics.collectd.SecurityLevel;
import com.codahale.metrics.collectd.Sender;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectdReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CollectdReporter.class);
    private static final String REPORTER_NAME = "collectd-reporter";
    private static final String FALLBACK_HOST_NAME = "localhost";
    private static final String COLLECTD_TYPE_GAUGE = "gauge";
    private String hostName;
    private final Sender sender;
    private final Clock clock;
    private long period;
    private final PacketWriter writer;
    private final Sanitize sanitize;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private CollectdReporter(MetricRegistry registry, String hostname, Sender sender, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Clock clock, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, Set<MetricAttribute> disabledMetricAttributes, String username, String password, SecurityLevel securityLevel, Sanitize sanitize) {
        super(registry, REPORTER_NAME, filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.hostName = hostname != null ? hostname : this.resolveHostName();
        this.sender = sender;
        this.clock = clock;
        this.sanitize = sanitize;
        this.writer = new PacketWriter(sender, username, password, securityLevel);
    }

    private String resolveHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Failed to lookup local host name: {}", (Object)e.getMessage(), (Object)e);
            return FALLBACK_HOST_NAME;
        }
    }

    public void start(long period, TimeUnit unit) {
        this.period = period;
        super.start(period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        MetaData.Builder metaData = new MetaData.Builder(this.sanitize, this.hostName, this.clock.getTime() / 1000L, this.period).type(COLLECTD_TYPE_GAUGE);
        try {
            this.connect(this.sender);
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.serializeGauge(metaData.plugin(entry.getKey()), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.serializeCounter(metaData.plugin(entry.getKey()), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.serializeHistogram(metaData.plugin(entry.getKey()), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.serializeMeter(metaData.plugin(entry.getKey()), (Meter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.serializeTimer(metaData.plugin(entry.getKey()), (Timer)entry.getValue());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to report to Collectd", (Throwable)e);
        }
        finally {
            this.disconnect(this.sender);
        }
    }

    private void connect(Sender sender) throws IOException {
        if (!sender.isConnected()) {
            sender.connect();
        }
    }

    private void disconnect(Sender sender) {
        try {
            sender.disconnect();
        }
        catch (Exception e) {
            LOG.warn("Error disconnecting from Collectd", (Throwable)e);
        }
    }

    private void writeValue(MetaData.Builder metaData, MetricAttribute attribute, Number value) {
        if (!this.getDisabledMetricAttributes().contains(attribute)) {
            this.write(metaData.typeInstance(attribute.getCode()).get(), value);
        }
    }

    private void writeRate(MetaData.Builder metaData, MetricAttribute attribute, double rate) {
        this.writeValue(metaData, attribute, this.convertRate(rate));
    }

    private void writeDuration(MetaData.Builder metaData, MetricAttribute attribute, double duration) {
        this.writeValue(metaData, attribute, this.convertDuration(duration));
    }

    private void write(MetaData metaData, Number value) {
        try {
            this.writer.write(metaData, value);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to process metric '" + metaData.getPlugin() + "': " + e.getMessage());
        }
        catch (IOException e) {
            LOG.error("Failed to send metric to collectd", (Throwable)e);
        }
    }

    private void serializeGauge(MetaData.Builder metaData, Gauge metric) {
        if (metric.getValue() instanceof Number) {
            this.write(metaData.typeInstance("value").get(), (Number)metric.getValue());
        } else if (metric.getValue() instanceof Boolean) {
            this.write(metaData.typeInstance("value").get(), (Boolean)metric.getValue() != false ? 1 : 0);
        } else {
            LOG.warn("Failed to process metric '{}'. Unsupported gauge of type: {} ", (Object)metaData.get().getPlugin(), (Object)metric.getValue().getClass().getName());
        }
    }

    private void serializeMeter(MetaData.Builder metaData, Meter metric) {
        this.writeValue(metaData, MetricAttribute.COUNT, metric.getCount());
        this.writeRate(metaData, MetricAttribute.M1_RATE, metric.getOneMinuteRate());
        this.writeRate(metaData, MetricAttribute.M5_RATE, metric.getFiveMinuteRate());
        this.writeRate(metaData, MetricAttribute.M15_RATE, metric.getFifteenMinuteRate());
        this.writeRate(metaData, MetricAttribute.MEAN_RATE, metric.getMeanRate());
    }

    private void serializeCounter(MetaData.Builder metaData, Counter metric) {
        this.writeValue(metaData, MetricAttribute.COUNT, metric.getCount());
    }

    private void serializeHistogram(MetaData.Builder metaData, Histogram metric) {
        Snapshot snapshot = metric.getSnapshot();
        this.writeValue(metaData, MetricAttribute.COUNT, metric.getCount());
        this.writeValue(metaData, MetricAttribute.MAX, snapshot.getMax());
        this.writeValue(metaData, MetricAttribute.MEAN, snapshot.getMean());
        this.writeValue(metaData, MetricAttribute.MIN, snapshot.getMin());
        this.writeValue(metaData, MetricAttribute.STDDEV, snapshot.getStdDev());
        this.writeValue(metaData, MetricAttribute.P50, snapshot.getMedian());
        this.writeValue(metaData, MetricAttribute.P75, snapshot.get75thPercentile());
        this.writeValue(metaData, MetricAttribute.P95, snapshot.get95thPercentile());
        this.writeValue(metaData, MetricAttribute.P98, snapshot.get98thPercentile());
        this.writeValue(metaData, MetricAttribute.P99, snapshot.get99thPercentile());
        this.writeValue(metaData, MetricAttribute.P999, snapshot.get999thPercentile());
    }

    private void serializeTimer(MetaData.Builder metaData, Timer metric) {
        Snapshot snapshot = metric.getSnapshot();
        this.writeValue(metaData, MetricAttribute.COUNT, metric.getCount());
        this.writeDuration(metaData, MetricAttribute.MAX, snapshot.getMax());
        this.writeDuration(metaData, MetricAttribute.MEAN, snapshot.getMean());
        this.writeDuration(metaData, MetricAttribute.MIN, snapshot.getMin());
        this.writeDuration(metaData, MetricAttribute.STDDEV, snapshot.getStdDev());
        this.writeDuration(metaData, MetricAttribute.P50, snapshot.getMedian());
        this.writeDuration(metaData, MetricAttribute.P75, snapshot.get75thPercentile());
        this.writeDuration(metaData, MetricAttribute.P95, snapshot.get95thPercentile());
        this.writeDuration(metaData, MetricAttribute.P98, snapshot.get98thPercentile());
        this.writeDuration(metaData, MetricAttribute.P99, snapshot.get99thPercentile());
        this.writeDuration(metaData, MetricAttribute.P999, snapshot.get999thPercentile());
        this.writeRate(metaData, MetricAttribute.M1_RATE, metric.getOneMinuteRate());
        this.writeRate(metaData, MetricAttribute.M5_RATE, metric.getFiveMinuteRate());
        this.writeRate(metaData, MetricAttribute.M15_RATE, metric.getFifteenMinuteRate());
        this.writeRate(metaData, MetricAttribute.MEAN_RATE, metric.getMeanRate());
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String hostName;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop = true;
        private Clock clock = Clock.defaultClock();
        private TimeUnit rateUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private MetricFilter filter = MetricFilter.ALL;
        private SecurityLevel securityLevel = SecurityLevel.NONE;
        private String username = "";
        private String password = "";
        private Set<MetricAttribute> disabledMetricAttributes = Collections.emptySet();
        private int maxLength = 63;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withSecurityLevel(SecurityLevel securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> attributes) {
            this.disabledMetricAttributes = attributes;
            return this;
        }

        public Builder withMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public CollectdReporter build(Sender sender) {
            if (this.securityLevel != SecurityLevel.NONE) {
                if (this.username.isEmpty()) {
                    throw new IllegalArgumentException("username is required for securityLevel: " + (Object)((Object)this.securityLevel));
                }
                if (this.password.isEmpty()) {
                    throw new IllegalArgumentException("password is required for securityLevel: " + (Object)((Object)this.securityLevel));
                }
            }
            return new CollectdReporter(this.registry, this.hostName, sender, this.executor, this.shutdownExecutorOnStop, this.clock, this.rateUnit, this.durationUnit, this.filter, this.disabledMetricAttributes, this.username, this.password, this.securityLevel, new Sanitize(this.maxLength));
        }
    }
}

