/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbMigrateCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private PrintStream outputStream = System.out;

    @VisibleForTesting
    void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public DbMigrateCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super("migrate", "Apply all pending change sets.", strategy, configurationClass, migrationsFileName);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-n", "--dry-run"}).action((ArgumentAction)Arguments.storeTrue()).dest("dry-run").setDefault((Object)Boolean.FALSE).help("output the DDL to stdout, don't run it");
        subparser.addArgument(new String[]{"-c", "--count"}).type(Integer.class).dest("count").help("only apply the next N change sets");
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        String context = this.getContext(namespace);
        Integer count = namespace.getInt("count");
        boolean dryRun = (Boolean)MoreObjects.firstNonNull((Object)namespace.getBoolean("dry-run"), (Object)false);
        if (count != null) {
            if (dryRun) {
                liquibase.update(count.intValue(), context, (Writer)new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8));
            } else {
                liquibase.update(count.intValue(), context);
            }
        } else if (dryRun) {
            liquibase.update(context, (Writer)new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8));
        } else {
            liquibase.update(context);
        }
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return Joiner.on((char)',').join((Iterable)contexts);
    }
}

