/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.PrintStream;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbLocksCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private PrintStream printStream = System.out;

    public DbLocksCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super("locks", "Manage database migration locks", strategy, configurationClass, migrationsFileName);
    }

    @VisibleForTesting
    void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-l", "--list"}).dest("list").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.FALSE).help("list all open locks");
        subparser.addArgument(new String[]{"-r", "--force-release"}).dest("release").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.FALSE).help("forcibly release all open locks");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        boolean release;
        boolean list = (Boolean)MoreObjects.firstNonNull((Object)namespace.getBoolean("list"), (Object)false);
        if (list == (release = ((Boolean)MoreObjects.firstNonNull((Object)namespace.getBoolean("release"), (Object)false)).booleanValue())) {
            throw new IllegalArgumentException("Must specify either --list or --force-release");
        }
        if (list) {
            liquibase.reportLocks(this.printStream);
        } else {
            liquibase.forceReleaseLocks();
        }
    }
}

