/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import io.dropwizard.migrations.DbCalculateChecksumCommand;
import io.dropwizard.migrations.DbClearChecksumsCommand;
import io.dropwizard.migrations.DbDropAllCommand;
import io.dropwizard.migrations.DbDumpCommand;
import io.dropwizard.migrations.DbFastForwardCommand;
import io.dropwizard.migrations.DbGenerateDocsCommand;
import io.dropwizard.migrations.DbLocksCommand;
import io.dropwizard.migrations.DbMigrateCommand;
import io.dropwizard.migrations.DbPrepareRollbackCommand;
import io.dropwizard.migrations.DbRollbackCommand;
import io.dropwizard.migrations.DbStatusCommand;
import io.dropwizard.migrations.DbTagCommand;
import io.dropwizard.migrations.DbTestCommand;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private static final String COMMAND_NAME_ATTR = "subcommand";
    private final SortedMap<String, AbstractLiquibaseCommand<T>> subcommands = new TreeMap<String, AbstractLiquibaseCommand<T>>();

    public DbCommand(String name, DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super(name, "Run database migration tasks", strategy, configurationClass, migrationsFileName);
        this.addSubcommand(new DbCalculateChecksumCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbClearChecksumsCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbDropAllCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbDumpCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbFastForwardCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbGenerateDocsCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbLocksCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbMigrateCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbPrepareRollbackCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbRollbackCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbStatusCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbTagCommand<T>(strategy, configurationClass, migrationsFileName));
        this.addSubcommand(new DbTestCommand<T>(strategy, configurationClass, migrationsFileName));
    }

    private void addSubcommand(AbstractLiquibaseCommand<T> subcommand) {
        this.subcommands.put(subcommand.getName(), subcommand);
    }

    @Override
    public void configure(Subparser subparser) {
        for (AbstractLiquibaseCommand<T> subcommand : this.subcommands.values()) {
            Subparser cmdParser = subparser.addSubparsers().addParser(subcommand.getName()).setDefault(COMMAND_NAME_ATTR, (Object)subcommand.getName()).description(subcommand.getDescription());
            subcommand.configure(cmdParser);
        }
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        AbstractLiquibaseCommand subcommand = Objects.requireNonNull((AbstractLiquibaseCommand)((Object)this.subcommands.get(namespace.getString(COMMAND_NAME_ATTR))), "Unable find the command");
        subcommand.run(namespace, liquibase);
    }
}

