/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.validation.constraints.Min;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.PushCacheFilter;

public class ServerPushFilterFactory {
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private boolean enabled = false;
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS) Duration associatePeriod = Duration.seconds((long)4L);
    @Min(value=1L)
    private int maxAssociations = 16;
    @Nullable
    private List<String> refererHosts;
    @Nullable
    private List<Integer> refererPorts;

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty
    public Duration getAssociatePeriod() {
        return this.associatePeriod;
    }

    @JsonProperty
    public void setAssociatePeriod(Duration associatePeriod) {
        this.associatePeriod = associatePeriod;
    }

    @JsonProperty
    public int getMaxAssociations() {
        return this.maxAssociations;
    }

    @JsonProperty
    public void setMaxAssociations(int maxAssociations) {
        this.maxAssociations = maxAssociations;
    }

    @Nullable
    @JsonProperty
    public List<String> getRefererHosts() {
        return this.refererHosts;
    }

    @JsonProperty
    public void setRefererHosts(@Nullable List<String> refererHosts) {
        this.refererHosts = refererHosts;
    }

    @Nullable
    @JsonProperty
    public List<Integer> getRefererPorts() {
        return this.refererPorts;
    }

    @JsonProperty
    public void setRefererPorts(@Nullable List<Integer> refererPorts) {
        this.refererPorts = refererPorts;
    }

    public void addFilter(ServletContextHandler handler) {
        if (!this.enabled) {
            return;
        }
        handler.setInitParameter("associatePeriod", String.valueOf(this.associatePeriod.toMilliseconds()));
        handler.setInitParameter("maxAssociations", String.valueOf(this.maxAssociations));
        if (this.refererHosts != null) {
            handler.setInitParameter("hosts", COMMA_JOINER.join(this.refererHosts));
        }
        if (this.refererPorts != null) {
            handler.setInitParameter("ports", COMMA_JOINER.join(this.refererPorts));
        }
        handler.addFilter(PushCacheFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }
}

