/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JacksonMessageBodyProvider
extends JacksonXmlBindJsonProvider {
    private final ObjectMapper mapper;

    public JacksonMessageBodyProvider(ObjectMapper mapper) {
        this.mapper = mapper;
        this.setMapper(mapper);
    }

    public boolean isReadable(Class<?> type, @Nullable Type genericType, @Nullable Annotation[] annotations, @Nullable MediaType mediaType) {
        return this.isProvidable(type) && super.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, @Nullable Type genericType, @Nullable Annotation[] annotations, @Nullable MediaType mediaType) {
        return this.isProvidable(type) && super.isWriteable(type, genericType, annotations, mediaType);
    }

    private boolean isProvidable(Class<?> type) {
        JsonIgnoreType ignore = type.getAnnotation(JsonIgnoreType.class);
        return ignore == null || !ignore.value();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

