/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import io.dropwizard.util.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class AbstractParamConverter<T>
implements ParamConverter<T> {
    private final Constructor<T> constructor;
    private final String parameterName;
    @Nullable
    private final String defaultValue;

    public AbstractParamConverter(Constructor<T> constructor, String parameterName, @Nullable String defaultValue) {
        this.constructor = constructor;
        this.parameterName = parameterName;
        this.defaultValue = defaultValue;
    }

    @Nullable
    public T fromString(String value) {
        try {
            if (Strings.isNullOrEmpty((String)value) && this.defaultValue != null && !this.defaultValue.equals(value)) {
                return this._fromString(this.defaultValue);
            }
            return this._fromString(value);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new ExtractorException(cause);
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
    }

    private T _fromString(String value) throws Exception {
        return this.constructor.newInstance(value, this.parameterName);
    }

    public String toString(T value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL((Object)"value"));
        }
        return value.toString();
    }
}

