/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class EofExceptionWriterInterceptor
implements WriterInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EofExceptionWriterInterceptor.class);
    private final Counter exceptionCounter;

    @Inject
    public EofExceptionWriterInterceptor(MetricRegistry metricRegistry) {
        this.exceptionCounter = metricRegistry.counter(MetricRegistry.name(this.getClass(), (String[])new String[]{"eof-exceptions"}));
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (EofException e) {
            LOGGER.debug("Client disconnected while processing and sending response", (Throwable)e);
            this.exceptionCounter.inc();
        }
    }
}

