/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.check.tcp;

import com.codahale.metrics.health.HealthCheck;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpHealthCheck
extends HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpHealthCheck.class);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);
    @Nonnull
    private final String host;
    private final int port;
    private final Duration connectionTimeout;

    public TcpHealthCheck(@Nonnull String host, int port) {
        this(host, port, DEFAULT_CONNECTION_TIMEOUT);
    }

    public TcpHealthCheck(@Nonnull String host, int port, Duration connectionTimeout) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
        if (connectionTimeout.isNegative()) {
            throw new IllegalStateException("connectionTimeout must be a non-negative value.");
        }
        if (connectionTimeout.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot configure a connectionTimeout greater than the max integer value");
        }
        this.connectionTimeout = connectionTimeout;
    }

    protected HealthCheck.Result check() throws IOException {
        boolean isHealthy = this.tcpCheck(this.host, this.port);
        if (isHealthy) {
            LOGGER.debug("Health check against url={}:{} successful", (Object)this.host, (Object)this.port);
            return HealthCheck.Result.healthy();
        }
        LOGGER.debug("Health check against url={}:{} failed", (Object)this.host, (Object)this.port);
        return HealthCheck.Result.unhealthy((String)"TCP health check against host=%s port=%s failed", (Object[])new Object[]{this.host, this.port});
    }

    protected boolean tcpCheck(String host, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), (int)this.connectionTimeout.toMillis());
            boolean bl = socket.isConnected();
            return bl;
        }
    }

    Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }
}

