/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient.InstrumentedHttpClientConnectionManager;
import com.codahale.metrics.httpclient.InstrumentedHttpRequestExecutor;
import io.dropwizard.client.ConfiguredCloseableHttpClient;
import io.dropwizard.client.DropwizardSSLConnectionSocketFactory;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.client.proxy.AuthConfiguration;
import io.dropwizard.client.proxy.NonProxyListProxyRoutePlanner;
import io.dropwizard.client.proxy.ProxyConfiguration;
import io.dropwizard.client.ssl.TlsConfiguration;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

public class HttpClientBuilder {
    private static final HttpRequestRetryHandler NO_RETRIES = (exception, executionCount, context) -> false;
    private final MetricRegistry metricRegistry;
    @Nullable
    private String environmentName;
    @Nullable
    private Environment environment;
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    @Nullable
    private HostnameVerifier verifier;
    @Nullable
    private HttpRequestRetryHandler httpRequestRetryHandler;
    @Nullable
    private Registry<ConnectionSocketFactory> registry;
    @Nullable
    private CredentialsProvider credentialsProvider;
    private HttpClientMetricNameStrategy metricNameStrategy = HttpClientMetricNameStrategies.METHOD_ONLY;
    @Nullable
    private HttpRoutePlanner routePlanner;
    @Nullable
    private RedirectStrategy redirectStrategy;
    private boolean disableContentCompression;
    @Nullable
    private List<? extends Header> defaultHeaders;
    @Nullable
    private HttpProcessor httpProcessor;
    @Nullable
    private ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;

    public HttpClientBuilder(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public HttpClientBuilder(Environment environment) {
        this(environment.metrics());
        this.name(environment.getName());
        this.environment = environment;
    }

    public HttpClientBuilder name(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public HttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public HttpClientBuilder using(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public HttpClientBuilder using(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        return this;
    }

    public HttpClientBuilder using(Registry<ConnectionSocketFactory> registry) {
        this.registry = registry;
        return this;
    }

    public HttpClientBuilder using(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        return this;
    }

    public HttpClientBuilder using(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public HttpClientBuilder using(HttpClientMetricNameStrategy metricNameStrategy) {
        this.metricNameStrategy = metricNameStrategy;
        return this;
    }

    public HttpClientBuilder using(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public HttpClientBuilder using(List<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public HttpClientBuilder using(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    @Deprecated
    public HttpClientBuilder using(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this.serviceUnavailableRetryStrategy = serviceUnavailableRetryStrategy;
        return this;
    }

    public HttpClientBuilder disableContentCompression(boolean disableContentCompression) {
        this.disableContentCompression = disableContentCompression;
        return this;
    }

    public CloseableHttpClient build(String name) {
        final CloseableHttpClient client = this.buildWithDefaultRequestConfiguration(name).getClient();
        if (this.environment != null) {
            this.environment.lifecycle().manage(new Managed(){

                public void stop() throws Exception {
                    client.close();
                }
            });
        }
        return client;
    }

    ConfiguredCloseableHttpClient buildWithDefaultRequestConfiguration(String name) {
        return this.createClient(this.createBuilder(), this.createConnectionManager(this.createConfiguredRegistry(), name), name);
    }

    protected HttpRequestExecutor createRequestExecutor(String name) {
        return new InstrumentedHttpRequestExecutor(this.metricRegistry, this.metricNameStrategy, name);
    }

    protected org.apache.http.impl.client.HttpClientBuilder createBuilder() {
        return org.apache.http.impl.client.HttpClientBuilder.create();
    }

    protected org.apache.http.impl.client.HttpClientBuilder customizeBuilder(org.apache.http.impl.client.HttpClientBuilder builder) {
        return builder;
    }

    protected ConfiguredCloseableHttpClient createClient(org.apache.http.impl.client.HttpClientBuilder builder, InstrumentedHttpClientConnectionManager manager, String name) {
        ProxyConfiguration proxy;
        NoConnectionReuseStrategy reuseStrategy;
        String cookiePolicy = this.configuration.isCookiesEnabled() ? "default" : "ignoreCookies";
        Integer timeout = (int)this.configuration.getTimeout().toMilliseconds();
        Integer connectionTimeout = (int)this.configuration.getConnectionTimeout().toMilliseconds();
        Integer connectionRequestTimeout = (int)this.configuration.getConnectionRequestTimeout().toMilliseconds();
        boolean normalizeUri = this.configuration.isNormalizeUriEnabled();
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        Object object = reuseStrategy = keepAlive == 0L ? new NoConnectionReuseStrategy() : new DefaultConnectionReuseStrategy();
        HttpRequestRetryHandler retryHandler = this.configuration.getRetries() == 0 ? NO_RETRIES : (this.httpRequestRetryHandler == null ? new DefaultHttpRequestRetryHandler(this.configuration.getRetries(), false) : this.httpRequestRetryHandler);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec(cookiePolicy).setSocketTimeout(timeout.intValue()).setConnectTimeout(connectionTimeout.intValue()).setConnectionRequestTimeout(connectionRequestTimeout.intValue()).setNormalizeUri(normalizeUri).build();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(timeout.intValue()).build();
        builder.setRequestExecutor(this.createRequestExecutor(name)).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).setConnectionReuseStrategy((ConnectionReuseStrategy)reuseStrategy).setRetryHandler(retryHandler).setUserAgent(this.createUserAgent(name));
        if (keepAlive != 0L) {
            builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
        if ((proxy = this.configuration.getProxyConfiguration()) != null) {
            HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort().intValue(), proxy.getScheme());
            builder.setRoutePlanner((HttpRoutePlanner)new NonProxyListProxyRoutePlanner(httpHost, proxy.getNonProxyHosts()));
            AuthConfiguration auth = proxy.getAuth();
            if (auth != null) {
                if (this.credentialsProvider == null) {
                    this.credentialsProvider = new BasicCredentialsProvider();
                }
                AuthScope authScope = new AuthScope(httpHost, auth.getRealm(), auth.getAuthScheme());
                Credentials credentials = this.configureCredentials(auth);
                this.credentialsProvider.setCredentials(authScope, credentials);
            }
        }
        if (this.credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        if (this.routePlanner != null) {
            builder.setRoutePlanner(this.routePlanner);
        }
        if (this.disableContentCompression) {
            builder.disableContentCompression();
        }
        if (this.redirectStrategy != null) {
            builder.setRedirectStrategy(this.redirectStrategy);
        }
        if (this.defaultHeaders != null) {
            builder.setDefaultHeaders(this.defaultHeaders);
        }
        if (this.verifier != null) {
            builder.setSSLHostnameVerifier(this.verifier);
        }
        if (this.httpProcessor != null) {
            builder.setHttpProcessor(this.httpProcessor);
        }
        if (this.serviceUnavailableRetryStrategy != null) {
            builder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        }
        this.customizeBuilder(builder);
        return new ConfiguredCloseableHttpClient(builder.build(), requestConfig);
    }

    protected String createUserAgent(String name) {
        String defaultUserAgent = this.environmentName == null ? name : String.format("%s (%s)", this.environmentName, name);
        return this.configuration.getUserAgent().orElse(defaultUserAgent);
    }

    protected InstrumentedHttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, String name) {
        Duration ttl = this.configuration.getTimeToLive();
        InstrumentedHttpClientConnectionManager manager = InstrumentedHttpClientConnectionManager.builder((MetricRegistry)this.metricRegistry).socketFactoryRegistry(registry).dnsResolver(this.resolver).connTTL(ttl.getQuantity()).connTTLTimeUnit(ttl.getUnit()).name(name).build();
        return this.configureConnectionManager(manager);
    }

    Registry<ConnectionSocketFactory> createConfiguredRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        TlsConfiguration tlsConfiguration = this.configuration.getTlsConfiguration();
        if (tlsConfiguration == null && this.verifier != null) {
            tlsConfiguration = new TlsConfiguration();
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = tlsConfiguration == null ? SSLConnectionSocketFactory.getSocketFactory() : new DropwizardSSLConnectionSocketFactory(tlsConfiguration, this.verifier).getSocketFactory();
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
    }

    protected InstrumentedHttpClientConnectionManager configureConnectionManager(InstrumentedHttpClientConnectionManager connectionManager) {
        connectionManager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        connectionManager.setMaxTotal(this.configuration.getMaxConnections());
        connectionManager.setValidateAfterInactivity((int)this.configuration.getValidateAfterInactivityPeriod().toMilliseconds());
        return connectionManager;
    }

    protected Credentials configureCredentials(AuthConfiguration auth) {
        if (null != auth.getCredentialType() && auth.getCredentialType().equalsIgnoreCase("NT")) {
            return new NTCredentials(auth.getUsername(), auth.getPassword(), auth.getHostname(), auth.getDomain());
        }
        return new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword());
    }
}

