/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.expressions;

import io.delta.standalone.data.RowRecord;
import io.delta.standalone.expressions.LeafExpression;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.TimestampType;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class Column
extends LeafExpression {
    private final String name;
    private final DataType dataType;
    private final RowRecordEvaluator evaluator;

    public Column(String string, DataType dataType) {
        this.name = string;
        this.dataType = dataType;
        if (dataType instanceof IntegerType) {
            this.evaluator = rowRecord -> rowRecord.getInt(string);
        } else if (dataType instanceof LongType) {
            this.evaluator = rowRecord -> rowRecord.getLong(string);
        } else if (dataType instanceof ByteType) {
            this.evaluator = rowRecord -> rowRecord.getByte(string);
        } else if (dataType instanceof ShortType) {
            this.evaluator = rowRecord -> rowRecord.getShort(string);
        } else if (dataType instanceof BooleanType) {
            this.evaluator = rowRecord -> rowRecord.getBoolean(string);
        } else if (dataType instanceof FloatType) {
            this.evaluator = rowRecord -> Float.valueOf(rowRecord.getFloat(string));
        } else if (dataType instanceof DoubleType) {
            this.evaluator = rowRecord -> rowRecord.getDouble(string);
        } else if (dataType instanceof StringType) {
            this.evaluator = rowRecord -> rowRecord.getString(string);
        } else if (dataType instanceof BinaryType) {
            this.evaluator = rowRecord -> rowRecord.getBinary(string);
        } else if (dataType instanceof DecimalType) {
            this.evaluator = rowRecord -> rowRecord.getBigDecimal(string);
        } else if (dataType instanceof TimestampType) {
            this.evaluator = rowRecord -> rowRecord.getTimestamp(string);
        } else if (dataType instanceof DateType) {
            this.evaluator = rowRecord -> rowRecord.getDate(string);
        } else {
            throw new UnsupportedOperationException("The data type of column " + string + " is " + dataType.getTypeName() + ". This is not supported yet.");
        }
    }

    public String name() {
        return this.name;
    }

    @Override
    public Object eval(RowRecord rowRecord) {
        return rowRecord.isNullAt(this.name) ? null : this.evaluator.nullSafeEval(rowRecord);
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        return "Column(" + this.name + ")";
    }

    @Override
    public Set<String> references() {
        return Collections.singleton(this.name);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Column column = (Column)object;
        return Objects.equals(this.name, column.name) && Objects.equals(this.dataType, column.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.dataType);
    }

    @FunctionalInterface
    private static interface RowRecordEvaluator {
        public Object nullSafeEval(RowRecord var1);
    }
}

