/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.types.StructType;
import java.util.Iterator;
import java.util.List;

public class TableFeatures {
    public static void validateReadSupportedTable(Protocol protocol, Metadata metadata, String string) {
        switch (protocol.getMinReaderVersion()) {
            case 1: {
                break;
            }
            case 2: {
                ColumnMapping.throwOnUnsupportedColumnMappingMode(metadata);
                break;
            }
            case 3: {
                List<String> list = protocol.getReaderFeatures();
                Iterator<String> iterator = list.iterator();
                block16: while (iterator.hasNext()) {
                    String string2;
                    switch (string2 = iterator.next()) {
                        case "columnMapping": {
                            ColumnMapping.throwOnUnsupportedColumnMappingMode(metadata);
                            continue block16;
                        }
                        case "deletionVectors": 
                        case "timestampNtz": 
                        case "vacuumProtocolCheck": 
                        case "v2Checkpoint": {
                            continue block16;
                        }
                    }
                    throw DeltaErrors.unsupportedReaderFeature(string, string2);
                }
                break;
            }
            default: {
                throw DeltaErrors.unsupportedReaderProtocol(string, protocol.getMinReaderVersion());
            }
        }
    }

    public static void validateWriteSupportedTable(Protocol protocol, Metadata metadata, StructType structType, String string) {
        int n = protocol.getMinWriterVersion();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                TableFeatures.validateNoInvariants(structType);
                break;
            }
            case 3: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 4: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 5: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 6: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 7: {
                Iterator<String> iterator = protocol.getWriterFeatures().iterator();
                block15: while (iterator.hasNext()) {
                    String string2;
                    switch (string2 = iterator.next()) {
                        case "appendOnly": {
                            continue block15;
                        }
                    }
                    throw DeltaErrors.unsupportedWriterFeature(string, string2);
                }
                break;
            }
            default: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
        }
    }

    private static void validateNoInvariants(StructType structType) {
        boolean bl = structType.fields().stream().anyMatch(structField -> structField.getMetadata().contains("delta.invariants"));
        if (bl) {
            throw DeltaErrors.columnInvariantsNotSupported();
        }
    }
}

