/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.ScanBuilder;
import io.delta.kernel.Snapshot;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.ScanBuilderImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.types.StructType;
import java.util.Optional;

public class SnapshotImpl
implements Snapshot {
    private final Path logPath;
    private final Path dataPath;
    private final long version;
    private final LogReplay logReplay;
    private final Protocol protocol;
    private final Metadata metadata;
    private final LogSegment logSegment;

    public SnapshotImpl(Path path, LogSegment logSegment, LogReplay logReplay, Protocol protocol, Metadata metadata) {
        this.logPath = new Path(path, "_delta_log");
        this.dataPath = path;
        this.version = logSegment.version;
        this.logSegment = logSegment;
        this.logReplay = logReplay;
        this.protocol = protocol;
        this.metadata = metadata;
    }

    @Override
    public long getVersion(Engine engine) {
        return this.version;
    }

    @Override
    public StructType getSchema(Engine engine) {
        return this.getMetadata().getSchema();
    }

    @Override
    public ScanBuilder getScanBuilder(Engine engine) {
        return new ScanBuilderImpl(this.dataPath, this.protocol, this.metadata, this.getSchema(engine), this.logReplay, engine);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public CreateCheckpointIterator getCreateCheckpointIterator(Engine engine) {
        long l = System.currentTimeMillis() - TableConfig.TOMBSTONE_RETENTION.fromMetadata(this.metadata);
        return new CreateCheckpointIterator(engine, this.logSegment, l);
    }

    public Optional<Long> getLatestTransactionVersion(String string) {
        return this.logReplay.getLatestTransactionIdentifier(string);
    }

    public LogSegment getLogSegment() {
        return this.logSegment;
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }
}

