package io.dekorate.knative.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class AutoScalingBuilder extends AutoScalingFluent<AutoScalingBuilder> implements VisitableBuilder<AutoScaling,AutoScalingBuilder>{
  public AutoScalingBuilder() {
    this(false);
  }
  public AutoScalingBuilder(Boolean validationEnabled) {
    this(new AutoScaling(), validationEnabled);
  }
  public AutoScalingBuilder(AutoScalingFluent<?> fluent) {
    this(fluent, false);
  }
  public AutoScalingBuilder(AutoScalingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AutoScaling(), validationEnabled);
  }
  public AutoScalingBuilder(AutoScalingFluent<?> fluent,AutoScaling instance) {
    this(fluent, instance, false);
  }
  public AutoScalingBuilder(AutoScalingFluent<?> fluent,AutoScaling instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AutoScaling());

    if (instance != null) {
      fluent.withAutoScalerClass(instance.getAutoScalerClass());
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withContainerConcurrency(instance.getContainerConcurrency());
      fluent.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AutoScalingBuilder(AutoScaling instance) {
    this(instance,false);
  }
  public AutoScalingBuilder(AutoScaling instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AutoScaling());

    if (instance != null) {
      this.withAutoScalerClass(instance.getAutoScalerClass());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withContainerConcurrency(instance.getContainerConcurrency());
      this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  AutoScalingFluent<?> fluent;
  Boolean validationEnabled;
  public EditableAutoScaling build() {
    EditableAutoScaling buildable = new EditableAutoScaling(fluent.getAutoScalerClass(),fluent.getMetric(),fluent.getTarget(),fluent.getContainerConcurrency(),fluent.getTargetUtilizationPercentage());
    return buildable;
  }
  
}