/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.transforms.UnwrapFromEnvelope;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class UnwrapFromEnvelopeTest {
    private static final String DROP_DELETES = "drop.deletes";
    private static final String DROP_TOMBSTONES = "drop.tombstones";
    private static final String HANDLE_DELETES = "delete.handling.mode";

    @Test
    public void testTombstoneDroppedByDefault() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneDroppedConfigured() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "true");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneForwardConfigured() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isEqualTo((Object)tombstone);
        }
    }

    private SourceRecord createDeleteRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(SchemaBuilder.struct().build()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        Struct payload = envelope.delete((Object)before, null, Long.valueOf(System.nanoTime()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(SchemaBuilder.struct().build()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        Struct payload = envelope.create((Object)before, null, Long.valueOf(System.nanoTime()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createUnknownRecord() {
        Schema recordSchema = SchemaBuilder.struct().name("unknown").field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    private SourceRecord createUnknownUnnamedSchemaRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    @Test
    public void testDeleteDroppedByDefault() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testDeleteDroppedConfigured() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_DELETES, "true");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testDeleteFrowardConfigured() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_DELETES, "false");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    public void testHandleDeleteDrop() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "drop");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testHandleDeleteNone() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    public void testHandleDeleteRewrite() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
        }
    }

    @Test
    public void testHandleCreateRewrite() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"false");
        }
    }

    @Test
    public void testUnwrapCreateRecord() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
        }
    }

    @Test
    public void testIgnoreUnknownRecord() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unknownRecord)).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unnamedSchemaRecord)).isEqualTo((Object)unnamedSchemaRecord);
        }
    }
}

