/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.MaskStrings;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MaskStringsTest {
    private final Column column = Column.editor().name("col").jdbcType(12).create();
    private ValueConverter converter;

    @Test
    public void shouldTruncateStrings() {
        String maskValue = "*****";
        this.converter = new MaskStrings(maskValue).create(this.column);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123456").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12345").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1234").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert(null).toString()).isEqualTo((Object)maskValue);
    }
}

