/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeGrammarParser;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.TokenStream;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DataTypeGrammarParserTest {
    private final int TYPE = 1984;
    private DataTypeGrammarParser parser;
    private DataTypeGrammarParser.DataTypePattern pattern;
    private DataType type;

    @Before
    public void beforeEach() {
        this.parser = new DataTypeGrammarParser();
    }

    @Test
    public void shouldParseGrammarWithOneRequiredToken() {
        this.pattern = this.parser.parse(1984, "BOOLEAN");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("BOOLEAN"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("boolean"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithTwoRequiredTokens() {
        this.pattern = this.parser.parse(1984, "UNSIGNED INTEGER");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("UNSIGNED INTEGER"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("unsigned integer"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOptionalTokens() {
        this.pattern = this.parser.parse(1984, "[UNSIGNED] INTEGER");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("UNSIGNED INTEGER"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("unsigned integer"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"UNSIGNED INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("INTEGER"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("integer"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOptionalTokensAfterLength() {
        this.pattern = this.parser.parse(1984, "INTEGER[(L)] [UNSIGNED]");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("INTEGER"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("INTEGER(3)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER(3)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("INTEGER UNSIGNED"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER UNSIGNED");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER UNSIGNED");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("INTEGER(3) UNSIGNED"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"INTEGER UNSIGNED");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"INTEGER(3) UNSIGNED");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOneRequiredTokenAndLiteralLength() {
        this.pattern = this.parser.parse(1984, "BIT(3)");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("BIT(3)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BIT");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BIT(3)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOneRequiredTokenAndSetOfLiteralLengths() {
        this.pattern = this.parser.parse(1984, "BIT(3 | 4 | 5)");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("BIT(3)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BIT");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BIT(3)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("BIT(4)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(4L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BIT");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BIT(4)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("BIT(5)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(5L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BIT");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BIT(5)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("BIT(2)"));
        Assertions.assertThat((Object)this.type).isNull();
    }

    @Test
    public void shouldParseGrammarWithOneRequiredTokenAndLength() {
        this.pattern = this.parser.parse(1984, "BIT(L)");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("BIT(3)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"BIT");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"BIT(3)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOneRequiredTokenAndLengthAndScale() {
        this.pattern = this.parser.parse(1984, "NUMBER(L,S)");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("NUMBER ( 3, 2)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(2);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"NUMBER");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"NUMBER(3,2)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOneRequiredTokenAndLengthAndOptionalScale() {
        this.pattern = this.parser.parse(1984, "DECIMAL[(M[,D])]");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("DECIMAL"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("DECIMAL(5)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(5L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"DECIMAL(5)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("DECIMAL(5,3)"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(5L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(3);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"DECIMAL(5,3)");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldNotFindMatchingDataTypeIfInvalidOrIncomplete() {
        this.pattern = this.parser.parse(1984, "DECIMAL(3)");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("DECIMAL(3"));
        Assertions.assertThat((Object)this.type).isNull();
    }

    @Test
    public void shouldParseGrammarWithVariableNames() {
        this.pattern = this.parser.parse(1984, "TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("TEXT(3) CHARACTER SET utf8 COLLATE utf8_bin"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(3L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"TEXT CHARACTER SET utf8 COLLATE utf8_bin");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"TEXT(3) CHARACTER SET utf8 COLLATE utf8_bin");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithComplexVariableNames() {
        this.pattern = this.parser.parse(1984, "CHAR[(L)] BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("CHAR(60) BINARY CHARACTER SET utf8 COLLATE utf8_bin"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(60L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"CHAR BINARY CHARACTER SET utf8 COLLATE utf8_bin");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"CHAR(60) BINARY CHARACTER SET utf8 COLLATE utf8_bin");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("char  (  60  )  binary  DEFAULT  ''  NOT  NULL"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(60L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"CHAR BINARY");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"CHAR(60) BINARY");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldParseGrammarWithOptionalTokenLists() {
        this.pattern = this.parser.parse(1984, "TEXT [CHARACTER SET]");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("TEXT CHARACTER SET"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).isNull();
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"TEXT CHARACTER SET");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"TEXT CHARACTER SET");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    @Test
    public void shouldMatchTypeWithArrayDimensionsFollowingLengthAndScale() {
        this.pattern = this.parser.parse(1984, "DECIMAL[(M[,D])]{n}");
        Assertions.assertThat((Object)this.pattern).isNotNull();
        this.type = this.pattern.match(this.text("DECIMAL[3]"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).containsOnly(new int[]{3});
        Assertions.assertThat((long)this.type.length()).isEqualTo(-1L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(-1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"DECIMAL[3]");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
        this.type = this.pattern.match(this.text("DECIMAL(5,1)[3][6]"));
        Assertions.assertThat((int[])this.type.arrayDimensions()).containsOnly(new int[]{3, 6});
        Assertions.assertThat((long)this.type.length()).isEqualTo(5L);
        Assertions.assertThat((int)this.type.scale()).isEqualTo(1);
        Assertions.assertThat((String)this.type.name()).isEqualTo((Object)"DECIMAL");
        Assertions.assertThat((String)this.type.expression()).isEqualTo((Object)"DECIMAL(5,1)[3][6]");
        Assertions.assertThat((int)this.type.jdbcType()).isEqualTo(1984);
    }

    protected TokenStream text(String content) {
        return new TokenStream(content, (TokenStream.Tokenizer)new DdlTokenizer(true), false).start();
    }
}

