/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.TimestampAndDelta;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class TimestampAndDeltaSerializer
implements Serializer<TimestampAndDelta> {
    private static final int TIMESTAMP_SIZE = 8;
    private static final int DELTA_SIZE = 2;

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, TimestampAndDelta data) {
        if (data == null) {
            return null;
        }
        short delta = data.delta();
        ByteBuffer buf = ByteBuffer.allocate(8 + (delta != 0 ? 2 : 0));
        buf.putLong(data.timestamp());
        if (delta != 0) {
            buf.putShort(delta);
        }
        return buf.array();
    }

    public void close() {
    }
}

