/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.RestConfig;
import io.confluent.rest.SslClientAuth;
import java.util.List;
import java.util.Objects;

public final class SslConfig {
    private static final SslConfig DEFAULT_CONFIG = new SslConfig(new RestConfig(RestConfig.baseConfigDef()));
    private final RestConfig restConfig;

    SslConfig(RestConfig restConfig) {
        this.restConfig = Objects.requireNonNull(restConfig);
    }

    public static SslConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public SslClientAuth getClientAuth() {
        String clientAuthentication;
        switch (clientAuthentication = this.restConfig.originals().getOrDefault("ssl.client.authentication", "")) {
            case "NONE": {
                return SslClientAuth.NONE;
            }
            case "REQUESTED": {
                return SslClientAuth.WANT;
            }
            case "REQUIRED": {
                return SslClientAuth.NEED;
            }
        }
        if (this.restConfig.getBoolean("ssl.client.auth").booleanValue()) {
            return SslClientAuth.NEED;
        }
        return SslClientAuth.NONE;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.restConfig.getString("ssl.endpoint.identification.algorithm");
    }

    public List<String> getIncludeCipherSuites() {
        return this.restConfig.getList("ssl.cipher.suites");
    }

    public List<String> getIncludeProtocols() {
        return this.restConfig.getList("ssl.enabled.protocols");
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.restConfig.getString("ssl.keymanager.algorithm");
    }

    public String getKeyManagerPassword() {
        return this.restConfig.getPassword("ssl.key.password").value();
    }

    public String getKeyStorePassword() {
        return this.restConfig.getPassword("ssl.keystore.password").value();
    }

    public String getKeyStorePath() {
        return this.restConfig.getString("ssl.keystore.location");
    }

    public String getKeyStoreType() {
        return this.restConfig.getString("ssl.keystore.type");
    }

    public String getProtocol() {
        return this.restConfig.getString("ssl.protocol");
    }

    public String getProvider() {
        return this.restConfig.getString("ssl.provider");
    }

    public boolean getReloadOnKeyStoreChange() {
        return this.restConfig.getBoolean("ssl.keystore.reload");
    }

    public String getReloadOnKeyStoreChangePath() {
        if (!this.restConfig.getString("ssl.keystore.watch.location").isEmpty()) {
            return this.restConfig.getString("ssl.keystore.watch.location");
        }
        return this.getKeyStorePath();
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.restConfig.getString("ssl.trustmanager.algorithm");
    }

    public String getTrustStorePassword() {
        return this.restConfig.getPassword("ssl.truststore.password").value();
    }

    public String getTrustStorePath() {
        return this.restConfig.getString("ssl.truststore.location");
    }

    public String getTrustStoreType() {
        return this.restConfig.getString("ssl.truststore.type");
    }
}

