/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.confluent.rest.Application;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactory;
import io.confluent.rest.errorhandlers.NoJettyDefaultStackTraceErrorHandler;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationServer<T extends RestConfig>
extends Server {
    private final T config;
    private final List<Application<?>> applications;
    private final ImmutableMap<NamedURI, SslContextFactory> sslContextFactories;
    private static volatile int threadPoolRequestQueueCapacity;
    private List<NetworkTrafficServerConnector> connectors = new ArrayList<NetworkTrafficServerConnector>();
    private final List<NamedURI> listeners;
    private static final Logger log;

    static boolean isJava11Compatible() {
        String versionString = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        return majorVersion >= 11;
    }

    public ApplicationServer(T config) {
        this(config, ApplicationServer.createThreadPool(config));
    }

    public ApplicationServer(T config, ThreadPool threadPool) {
        super(threadPool);
        this.config = config;
        this.applications = new ArrayList();
        int gracefulShutdownMs = config.getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            super.setStopTimeout((long)gracefulShutdownMs);
        }
        super.setStopAtShutdown(true);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        super.addEventListener((Container.Listener)mbContainer);
        super.addBean((Object)mbContainer);
        this.listeners = ((RestConfig)((Object)config)).getListeners();
        this.sslContextFactories = ImmutableMap.copyOf((Map)Maps.transformValues(((RestConfig)((Object)config)).getSslConfigs(), SslFactory::createSslContextFactory));
        this.configureConnectors();
        this.configureConnectionLimits();
    }

    public void registerApplication(Application application) {
        application.setServer(this);
        this.applications.add(application);
    }

    public List<Application<?>> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    private void attachMetricsListener(Metrics metrics, Map<String, String> tags) {
        MetricsListener metricsListener = new MetricsListener(metrics, "jetty", tags);
        for (NetworkTrafficServerConnector connector : this.connectors) {
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
        }
    }

    private void addJettyThreadPoolMetrics(Metrics metrics, Map<String, String> tags) {
        String requestQueueSizeName = "request-queue-size";
        String metricGroupName = "jetty-metrics";
        MetricName requestQueueSizeMetricName = metrics.metricName(requestQueueSizeName, metricGroupName, "The number of requests in the jetty thread pool queue.", tags);
        Gauge queueSize = (config, now) -> this.getQueueSize();
        metrics.addMetric(requestQueueSizeMetricName, (MetricValueProvider)queueSize);
        String busyThreadCountName = "busy-thread-count";
        MetricName busyThreadCountMetricName = metrics.metricName(busyThreadCountName, metricGroupName, "jetty thread pool busy thread count.", tags);
        Gauge busyThreadCount = (config, now) -> this.getBusyThreads();
        metrics.addMetric(busyThreadCountMetricName, (MetricValueProvider)busyThreadCount);
        String threadPoolUsageName = "thread-pool-usage";
        MetricName threadPoolUsageMetricName = metrics.metricName(threadPoolUsageName, metricGroupName, " jetty thread pool usage.", Collections.emptyMap());
        Gauge threadPoolUsage = (config, now) -> (double)this.getBusyThreads() / (double)this.getMaxThreads();
        metrics.addMetric(threadPoolUsageMetricName, (MetricValueProvider)threadPoolUsage);
    }

    private void finalizeHandlerCollection(HandlerCollection handlers, HandlerCollection wsHandlers) {
        handlers.addHandler((Handler)new DefaultHandler());
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{statsHandler, wsHandlers});
        super.setHandler(this.wrapWithGzipHandler((Handler)contexts));
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (Application<?> application : this.applications) {
            application.getMetrics().close();
            application.doShutdown();
        }
    }

    protected final void doStart() throws Exception {
        if (((RestConfig)((Object)this.config)).getSuppressStackTraceInResponse()) {
            this.setErrorHandler(new NoJettyDefaultStackTraceErrorHandler());
        }
        HandlerCollection handlers = new HandlerCollection();
        HandlerCollection wsHandlers = new HandlerCollection();
        for (Application<?> app : this.applications) {
            this.attachMetricsListener(app.getMetrics(), app.getMetricsTags());
            this.addJettyThreadPoolMetrics(app.getMetrics(), app.getMetricsTags());
            handlers.addHandler(app.configureHandler());
            wsHandlers.addHandler(app.configureWebSocketHandler());
        }
        this.finalizeHandlerCollection(handlers, wsHandlers);
        super.doStart();
    }

    @Deprecated
    SslContextFactory getSslContextFactory() {
        return this.sslContextFactories.values().stream().findAny().orElse(SslFactory.createSslContextFactory(SslConfig.defaultConfig()));
    }

    public Map<NamedURI, SslContextFactory> getSslContextFactories() {
        return this.sslContextFactories;
    }

    private void configureConnectors() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        boolean http2Enabled = ApplicationServer.isJava11Compatible() && this.config.getBoolean("http2.enabled") != false;
        boolean proxyProtocolEnabled = this.config.getBoolean("proxy.protocol.enabled");
        for (NamedURI listener : this.listeners) {
            if (listener.getUri().getScheme().equals("https") && httpConfiguration.getCustomizer(SecureRequestCustomizer.class) == null) {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            this.addConnectorForListener(httpConfiguration, httpConnectionFactory, listener, http2Enabled, proxyProtocolEnabled);
        }
    }

    private void addConnectorForListener(HttpConfiguration httpConfiguration, HttpConnectionFactory httpConnectionFactory, NamedURI listener, boolean http2Enabled, boolean proxyProtocolEnabled) {
        ConnectionFactory[] connectionFactories = this.getConnectionFactories(httpConfiguration, httpConnectionFactory, listener, http2Enabled, proxyProtocolEnabled);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector((Server)this, null, null, null, 0, 0, connectionFactories);
        if (http2Enabled) {
            connector.addBean((Object)HttpCompliance.RFC7230);
        }
        connector.setPort(listener.getUri().getPort());
        connector.setHost(listener.getUri().getHost());
        connector.setIdleTimeout(this.config.getLong("idle.timeout.ms").longValue());
        if (listener.getName() != null) {
            connector.setName(listener.getName());
        }
        this.connectors.add(connector);
        super.addConnector((Connector)connector);
    }

    private ConnectionFactory[] getConnectionFactories(HttpConfiguration httpConfiguration, HttpConnectionFactory httpConnectionFactory, NamedURI listener, boolean http2Enabled, boolean proxyProtocolEnabled) {
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        if (http2Enabled) {
            log.info("Adding listener with HTTP/2: " + listener);
            if (listener.getUri().getScheme().equals("http")) {
                HTTP2CServerConnectionFactory h2cConnectionFactory = new HTTP2CServerConnectionFactory(httpConfiguration);
                if (proxyProtocolEnabled) {
                    connectionFactories.add(new ProxyConnectionFactory(httpConnectionFactory.getProtocol()));
                }
                connectionFactories.add(httpConnectionFactory);
                connectionFactories.add(h2cConnectionFactory);
            } else {
                HTTP2ServerConnectionFactory h2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfiguration);
                ALPNServerConnectionFactory alpnConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
                alpnConnectionFactory.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)this.sslContextFactories.get((Object)listener), alpnConnectionFactory.getProtocol());
                if (proxyProtocolEnabled) {
                    connectionFactories.add(new ProxyConnectionFactory(sslConnectionFactory.getProtocol()));
                }
                connectionFactories.add(sslConnectionFactory);
                connectionFactories.add(alpnConnectionFactory);
                connectionFactories.add(h2ConnectionFactory);
                connectionFactories.add(httpConnectionFactory);
            }
        } else {
            log.info("Adding listener: " + listener);
            if (listener.getUri().getScheme().equals("http")) {
                if (proxyProtocolEnabled) {
                    connectionFactories.add(new ProxyConnectionFactory(httpConnectionFactory.getProtocol()));
                }
            } else {
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)this.sslContextFactories.get((Object)listener), httpConnectionFactory.getProtocol());
                if (proxyProtocolEnabled) {
                    connectionFactories.add(new ProxyConnectionFactory(sslConnectionFactory.getProtocol()));
                }
                connectionFactories.add(sslConnectionFactory);
            }
            connectionFactories.add(httpConnectionFactory);
        }
        return connectionFactories.toArray(new ConnectionFactory[0]);
    }

    private void configureConnectionLimits() {
        int connectorConnectionLimit;
        int serverConnectionLimit = ((RestConfig)((Object)this.config)).getServerConnectionLimit();
        if (serverConnectionLimit > 0) {
            this.addBean(new ConnectionLimit(serverConnectionLimit, this.getServer()));
        }
        if ((connectorConnectionLimit = ((RestConfig)((Object)this.config)).getConnectorConnectionLimit()) > 0) {
            this.addBean(new ConnectionLimit(connectorConnectionLimit, this.connectors.toArray(new Connector[0])));
        }
    }

    public int getThreads() {
        return this.getThreadPool().getThreads();
    }

    public int getBusyThreads() {
        return ((QueuedThreadPool)this.getThreadPool()).getBusyThreads();
    }

    public int getMaxThreads() {
        return this.config.getInt("thread.pool.max");
    }

    public int getQueueSize() {
        return ((QueuedThreadPool)this.getThreadPool()).getQueueSize();
    }

    public int getQueueCapacity() {
        return threadPoolRequestQueueCapacity;
    }

    static Handler wrapWithGzipHandler(RestConfig config, Handler handler) {
        if (config.getBoolean("compression.enable").booleanValue()) {
            GzipHandler gzip = new GzipHandler();
            gzip.setIncludedMethods(new String[]{"GET", "POST"});
            gzip.setHandler(handler);
            return gzip;
        }
        return handler;
    }

    private Handler wrapWithGzipHandler(Handler handler) {
        return ApplicationServer.wrapWithGzipHandler(this.config, handler);
    }

    private static ThreadPool createThreadPool(RestConfig config) {
        int initialCapacity = config.getInt("request.queue.capacity.init");
        int growBy = config.getInt("request.queue.capacity.growby");
        int maxCapacity = config.getInt("request.queue.capacity");
        log.info("Initial capacity {}, increased by {}, maximum capacity {}.", new Object[]{initialCapacity, growBy, maxCapacity});
        if (initialCapacity > maxCapacity) {
            threadPoolRequestQueueCapacity = initialCapacity;
            log.warn("request.queue.capacity is less than request.queue.capacity.init, invalid config. Setting request.queue.capacity to request.queue.capacity.init.");
        } else {
            threadPoolRequestQueueCapacity = maxCapacity;
        }
        BlockingArrayQueue requestQueue = new BlockingArrayQueue(initialCapacity, growBy, threadPoolRequestQueueCapacity);
        return new QueuedThreadPool(config.getInt("thread.pool.max").intValue(), config.getInt("thread.pool.min").intValue(), (BlockingQueue)requestQueue);
    }

    static {
        log = LoggerFactory.getLogger(ApplicationServer.class);
    }
}

