/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client;

import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class RestClientConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "confluent.metadata.";
    private static final ConfigDef CONFIG;
    public static final String BOOTSTRAP_METADATA_SERVER_URLS_PROP = "confluent.metadata.bootstrap.server.urls";
    private static final String BOOTSTRAP_METADATA_SERVER_URLS_DOC = "Comma separated list of bootstrap metadata servers urls to which this client connects to. For ex: http://localhost:8080,http://localhost:8081";
    public static final String ENABLE_METADATA_SERVER_URL_REFRESH = "confluent.metadata.enable.server.urls.refresh";
    public static final String ENABLE_METADATA_SERVER_URL_REFRESH_DOC = "enables periodic refresh of metadata server urls.";
    public static final String METADATA_SERVER_URL_MAX_AGE_PROP = "confluent.metadata.server.urls.max.age.ms";
    public static final Long METADATA_SERVER_URL_MAX_AGE_DEFAULT;
    public static final String METADATA_SERVER_URL_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata server urls.";
    public static final String METADATA_SERVER_URL_MAX_RETRIES_PROP = "confluent.metadata.server.urls.max.retries";
    public static final Integer METADATA_SERVER_URL_MAX_RETRIES_DEFAULT;
    public static final String METADATA_SERVER_URL_MAX_RETRIES_DOC = "The number of retries to force a refresh of metadata server urls.";
    public static final String METADATA_SERVER_URL_FAIL_ON_401_PROP = "confluent.metadata.server.urls.fail.on.401";
    public static final Boolean METADATA_SERVER_URL_FAIL_ON_401_DEFAULT;
    public static final String METADATA_SERVER_URL_FAIL_ON_401_DOC = "When set to true, the client will fail immediately on receipt of 401 when trying to refresh metadata server urls. This might be useful if repeated 401 cause issues in the backing LDAP server.";
    public static final String HTTP_AUTH_CREDENTIALS_PROVIDER_PROP = "confluent.metadata.http.auth.credentials.provider";
    private static final String HTTP_AUTH_CREDENTIALS_PROVIDER_DEFAULT = "";
    private static final String HTTP_AUTH_CREDENTIALS_PROVIDER_DOC;
    public static final String BASIC_AUTH_CREDENTIALS_PROVIDER_PROP = "confluent.metadata.basic.auth.credentials.provider";
    private static final String BASIC_AUTH_CREDENTIALS_PROVIDER_DEFAULT;
    private static final String BASIC_AUTH_CREDENTIALS_PROVIDER_PROP_DOC;
    public static final String BASIC_AUTH_USER_INFO_PROP = "confluent.metadata.basic.auth.user.info";
    private static final String BASIC_AUTH_USER_INFO_PROP_DOC;
    public static final String BASIC_AUTH_CREDENTIALS_PATH_PROP = "confluent.metadata.basic.auth.credentials.path";
    private static final String BASIC_AUTH_CREDENTIALS_PATH_DOC = "Path name of user credentials file in Java properties file format or JSON format with the properties 'username' and 'password'.";
    public static final String TOKEN_AUTH_CREDENTIAL_PROP = "confluent.metadata.token.auth.credential";
    private static final String TOKEN_AUTH_CREDENTIAL_DEFAULT = "";
    private static final String TOKEN_AUTH_CREDENTIAL_DOC = "String representation of an Authentication Token";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "confluent.metadata.request.timeout.ms";
    public static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a each authorizer request.";
    public static final String HTTP_REQUEST_TIMEOUT_MS_CONFIG = "confluent.metadata.http.request.timeout.ms";
    public static final String HTTP_REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a http request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if all urls are exhausted. This value should less than or equal to confluent.metadata.request.timeout.ms config";

    public RestClientConfig(Map<?, ?> props) {
        super(CONFIG, props);
        this.validate();
    }

    public Map<String, ?> sslClientConfigs() {
        Map configs = this.originals();
        configs.putAll(this.originalsWithPrefix(CONFIG_PREFIX));
        configs.keySet().removeAll(this.originalsWithPrefix(CONFIG_PREFIX, false).keySet());
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        SslClientConfig sslClientConfig = new SslClientConfig(sslConfigDef, configs);
        return sslClientConfig.values();
    }

    private void validate() {
        if (this.getInt(HTTP_REQUEST_TIMEOUT_MS_CONFIG) > this.getInt(REQUEST_TIMEOUT_MS_CONFIG)) {
            throw new ConfigException("confluent.metadata.http.request.timeout.ms config value should be less than or equal to confluent.metadata.request.timeout.ms");
        }
    }

    public String toString() {
        return Utils.mkString((Map)this.values(), (String)"", (String)"", (String)"=", (String)"%n\t");
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }

    static {
        METADATA_SERVER_URL_MAX_AGE_DEFAULT = 600000L;
        METADATA_SERVER_URL_MAX_RETRIES_DEFAULT = 5;
        METADATA_SERVER_URL_FAIL_ON_401_DEFAULT = false;
        HTTP_AUTH_CREDENTIALS_PROVIDER_DOC = "HTTP authentication scheme. Supported schemes are " + BuiltInAuthProviders.builtInHttpCredentialProviders();
        BASIC_AUTH_CREDENTIALS_PROVIDER_DEFAULT = BuiltInAuthProviders.BasicAuthCredentialProviders.USER_INFO.name();
        BASIC_AUTH_CREDENTIALS_PROVIDER_PROP_DOC = "User credentials provider for the HTTP basic authentication. Supported providers are " + BuiltInAuthProviders.builtInBasicAuthCredentialProviders();
        BASIC_AUTH_USER_INFO_PROP_DOC = "Basic user credentials info in the format user:password. This is required for " + BuiltInAuthProviders.BasicAuthCredentialProviders.USER_INFO.name() + " provider.";
        CONFIG = new ConfigDef().define(BOOTSTRAP_METADATA_SERVER_URLS_PROP, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, BOOTSTRAP_METADATA_SERVER_URLS_DOC).define(HTTP_AUTH_CREDENTIALS_PROVIDER_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HTTP_AUTH_CREDENTIALS_PROVIDER_DOC).define(BASIC_AUTH_CREDENTIALS_PROVIDER_PROP, ConfigDef.Type.STRING, (Object)BASIC_AUTH_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.HIGH, BASIC_AUTH_CREDENTIALS_PROVIDER_PROP_DOC).define(BASIC_AUTH_USER_INFO_PROP, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, BASIC_AUTH_USER_INFO_PROP_DOC).define(BASIC_AUTH_CREDENTIALS_PATH_PROP, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BASIC_AUTH_CREDENTIALS_PATH_DOC).define(ENABLE_METADATA_SERVER_URL_REFRESH, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ENABLE_METADATA_SERVER_URL_REFRESH_DOC).define(METADATA_SERVER_URL_MAX_AGE_PROP, ConfigDef.Type.LONG, (Object)METADATA_SERVER_URL_MAX_AGE_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, METADATA_SERVER_URL_MAX_AGE_DOC).define(METADATA_SERVER_URL_MAX_RETRIES_PROP, ConfigDef.Type.INT, (Object)METADATA_SERVER_URL_MAX_RETRIES_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, METADATA_SERVER_URL_MAX_RETRIES_DOC).define(METADATA_SERVER_URL_FAIL_ON_401_PROP, ConfigDef.Type.BOOLEAN, (Object)METADATA_SERVER_URL_FAIL_ON_401_DEFAULT, ConfigDef.Importance.LOW, METADATA_SERVER_URL_FAIL_ON_401_DOC).define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(HTTP_REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)10000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, HTTP_REQUEST_TIMEOUT_MS_DOC).define(TOKEN_AUTH_CREDENTIAL_PROP, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.LOW, TOKEN_AUTH_CREDENTIAL_DOC);
    }

    private static class SslClientConfig
    extends AbstractConfig {
        SslClientConfig(ConfigDef configDef, Map<String, Object> props) {
            super(configDef, props);
        }
    }
}

