/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.auth.client.rest.RestRequest;
import io.confluent.security.auth.client.rest.entities.AuthorizeRequest;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.RequestContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuthorizer
implements Authorizer {
    private static final Logger log = LoggerFactory.getLogger(RestAuthorizer.class);
    private static final String AUTHORIZE_ENDPOINT = "/authorize";
    private static final String AUTHORIZE_METHOD = "PUT";
    private static final TypeReference<List<String>> AUTHORIZE_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private RestClient restClient;

    public RestAuthorizer() {
    }

    public RestAuthorizer(RestClient restClient) {
        this.restClient = restClient;
    }

    public void configure(Map<String, ?> configs) {
        if (this.restClient != null) {
            log.warn("Using the existing RestClient instance");
            return;
        }
        this.restClient = new RestClient(configs);
    }

    public List<AuthorizeResult> authorize(KafkaPrincipal sessionPrincipal, String host, List<Action> actions) {
        return this.doAuthorize(this.newAuthorizeRequest(sessionPrincipal, host, actions));
    }

    public List<AuthorizeResult> authorize(RequestContext requestContext, List<Action> actions) {
        return this.doAuthorize(this.newAuthorizeRequest(requestContext.principal(), requestContext.clientAddress().getHostAddress(), actions));
    }

    public List<AuthorizeResult> authorize(HttpCredentialProvider credentialProvider, KafkaPrincipal sessionPrincipal, String host, List<Action> actions) {
        return this.doAuthorize(credentialProvider, this.newAuthorizeRequest(sessionPrincipal, host, actions));
    }

    private RestRequest newAuthorizeRequest(KafkaPrincipal sessionPrincipal, String host, List<Action> actions) {
        if (this.restClient == null) {
            throw new IllegalStateException("RestClient has not been initialized.");
        }
        RestRequest request = this.restClient.newRequest(AUTHORIZE_ENDPOINT);
        AuthorizeRequest authorizeRequest = new AuthorizeRequest(sessionPrincipal.toString(), host, actions);
        request.setRequest(authorizeRequest);
        request.setRequestMethod(AUTHORIZE_METHOD);
        request.setResponse(AUTHORIZE_RESPONSE_TYPE);
        return request;
    }

    private List<AuthorizeResult> doAuthorize(HttpCredentialProvider credentialProvider, RestRequest request) {
        request.setCredentialProvider(credentialProvider);
        return this.doAuthorize(request);
    }

    private List<AuthorizeResult> doAuthorize(RestRequest request) {
        try {
            List results = (List)this.doRequest(request);
            return results.stream().map(AuthorizeResult::valueOf).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while executing authorize operation", e);
        }
    }

    private <T> T doRequest(RestRequest request) throws Exception {
        return this.restClient.sendRequest(request);
    }

    public void close() throws IOException {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

