/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client;

import io.confluent.ksql.api.client.KsqlObject;
import io.vertx.core.json.JsonArray;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class KsqlArray {
    private final JsonArray delegate;

    public KsqlArray() {
        this.delegate = new JsonArray();
    }

    public KsqlArray(List<?> list) {
        this.delegate = new JsonArray(list);
    }

    KsqlArray(JsonArray jsonArray) {
        this.delegate = Objects.requireNonNull(jsonArray);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public List<?> getList() {
        return this.delegate.getList();
    }

    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    public Stream<Object> stream() {
        return this.delegate.stream();
    }

    public Object getValue(int pos) {
        return this.delegate.getValue(pos);
    }

    public String getString(int pos) {
        return this.delegate.getString(pos);
    }

    public Integer getInteger(int pos) {
        return this.delegate.getInteger(pos);
    }

    public Long getLong(int pos) {
        return this.delegate.getLong(pos);
    }

    public Double getDouble(int pos) {
        return this.delegate.getDouble(pos);
    }

    public Boolean getBoolean(int pos) {
        return this.delegate.getBoolean(pos);
    }

    public BigDecimal getDecimal(int pos) {
        return new BigDecimal(this.getValue(pos).toString());
    }

    public byte[] getBytes(int pos) {
        return this.delegate.getBinary(pos);
    }

    public KsqlArray getKsqlArray(int pos) {
        return new KsqlArray(this.delegate.getJsonArray(pos));
    }

    public KsqlObject getKsqlObject(int pos) {
        return new KsqlObject(this.delegate.getJsonObject(pos));
    }

    public Object remove(int pos) {
        return this.delegate.remove(pos);
    }

    public boolean remove(Object value) {
        return this.delegate.remove(value);
    }

    public KsqlArray add(String value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(Integer value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(Long value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(Double value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(Boolean value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(BigDecimal value) {
        this.delegate.add((Object)value.toString());
        return this;
    }

    public KsqlArray add(byte[] value) {
        this.delegate.add((Object)value);
        return this;
    }

    public KsqlArray add(KsqlArray value) {
        this.delegate.add((Object)KsqlArray.toJsonArray(value));
        return this;
    }

    public KsqlArray add(KsqlObject value) {
        this.delegate.add((Object)KsqlObject.toJsonObject(value));
        return this;
    }

    public KsqlArray add(Object value) {
        this.delegate.add(value);
        return this;
    }

    public KsqlArray addNull() {
        this.delegate.addNull();
        return this;
    }

    public KsqlArray addAll(KsqlArray array) {
        this.delegate.addAll(KsqlArray.toJsonArray(array));
        return this;
    }

    public KsqlArray copy() {
        return new KsqlArray(this.delegate.copy());
    }

    public String toJsonString() {
        return this.delegate.toString();
    }

    public String toString() {
        return this.toJsonString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlArray that = (KsqlArray)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    static JsonArray toJsonArray(KsqlArray ksqlArray) {
        return new JsonArray(ksqlArray.getList());
    }
}

