/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import jakarta.validation.constraints.Min;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DeleteSubjectValue
extends SubjectValue {
    @Min(value=1L)
    private @Min(value=1L) Integer version;

    public DeleteSubjectValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version) {
        super(subject);
        this.version = version;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteSubjectValue that = (DeleteSubjectValue)o;
        return this.version.equals(that.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.getSubject() + ",");
        sb.append("version=" + this.version + "}");
        return sb.toString();
    }

    @Override
    public DeleteSubjectKey toKey() {
        return new DeleteSubjectKey(this.getSubject());
    }
}

