/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import jakarta.ws.rs.core.HttpHeaders;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.StringUtil;

public class RequestHeaderBuilder {
    public Map<String, String> buildRequestHeaders(HttpHeaders httpHeaders, List<String> whitelistedHeaders) {
        HashMap<String, String> headerProperties = new HashMap<String, String>();
        this.addStaticHeaders(headerProperties, httpHeaders);
        this.addWhitelistedHeaders(headerProperties, httpHeaders, whitelistedHeaders);
        return headerProperties;
    }

    private void addWhitelistedHeaders(Map<String, String> headerProperties, HttpHeaders httpHeaders, List<String> whitelistedHeaders) {
        if (whitelistedHeaders != null) {
            whitelistedHeaders.stream().forEach(headerToForward -> this.addIfNotEmpty(httpHeaders, headerProperties, (String)headerToForward));
        }
    }

    private void addStaticHeaders(Map<String, String> headerProperties, HttpHeaders httpHeaders) {
        this.addIfNotEmpty(httpHeaders, headerProperties, "Content-Type");
        this.addIfNotEmpty(httpHeaders, headerProperties, "Accept");
        this.addIfNotEmpty(httpHeaders, headerProperties, "Authorization");
        this.addIfNotEmpty(httpHeaders, headerProperties, "X-Request-ID");
    }

    private void addIfNotEmpty(HttpHeaders incomingHeaders, Map<String, String> headerProperties, String header) {
        String headerString = incomingHeaders.getHeaderString(header);
        if (StringUtil.isNotBlank((String)headerString)) {
            headerProperties.put(header, headerString);
        }
    }
}

