/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.rest.Application;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;

public class MetricsContainer {
    public static final String JMX_PREFIX = "kafka.schema.registry";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_KAFKA_CLUSTER_ID = "resource.kafka.cluster.id";
    public static final String METRIC_NAME_MASTER_SLAVE_ROLE = "master-slave-role";
    public static final String METRIC_NAME_NODE_COUNT = "node-count";
    public static final String METRIC_NAME_CUSTOM_SCHEMA_PROVIDER = "custom-schema-provider-count";
    public static final String METRIC_NAME_API_SUCCESS_COUNT = "api-success-count";
    public static final String METRIC_NAME_API_FAILURE_COUNT = "api-failure-count";
    public static final String METRIC_NAME_REGISTERED_COUNT = "registered-count";
    public static final String METRIC_NAME_DELETED_COUNT = "deleted-count";
    public static final String METRIC_NAME_AVRO_SCHEMAS_CREATED = "avro-schemas-created";
    public static final String METRIC_NAME_AVRO_SCHEMAS_DELETED = "avro-schemas-deleted";
    public static final String METRIC_NAME_JSON_SCHEMAS_CREATED = "json-schemas-created";
    public static final String METRIC_NAME_JSON_SCHEMAS_DELETED = "json-schemas-deleted";
    public static final String METRIC_NAME_PB_SCHEMAS_CREATED = "protobuf-schemas-created";
    public static final String METRIC_NAME_PB_SCHEMAS_DELETED = "protobuf-schemas-deleted";
    public static final String METRIC_LEADER_INITIALIZATION_LATENCY = "leader-initialization-latency";
    private final Metrics metrics;
    private final Map<String, String> configuredTags;
    private final SchemaRegistryMetric isLeaderNode;
    private final SchemaRegistryMetric nodeCount;
    private final SchemaRegistryMetric schemasCreated;
    private final SchemaRegistryMetric schemasDeleted;
    private final SchemaRegistryMetric customSchemaProviders;
    private final SchemaRegistryMetric apiCallsSuccess;
    private final SchemaRegistryMetric apiCallsFailure;
    private final SchemaRegistryMetric avroSchemasCreated;
    private final SchemaRegistryMetric jsonSchemasCreated;
    private final SchemaRegistryMetric protobufSchemasCreated;
    private final SchemaRegistryMetric avroSchemasDeleted;
    private final SchemaRegistryMetric jsonSchemasDeleted;
    private final SchemaRegistryMetric protobufSchemasDeleted;
    private final SchemaRegistryMetric leaderInitializationLatency;
    private final MetricsContext metricsContext;

    public MetricsContainer(SchemaRegistryConfig config, String kafkaClusterId) {
        this.configuredTags = Application.parseListToMap((List)config.getList("metrics.tag.map"));
        List reporters = config.getConfiguredInstances(config.getList("metric.reporters"), MetricsReporter.class, Collections.singletonMap("kafkastore.topic", config.getString("kafkastore.topic")));
        reporters.add(MetricsContainer.getJmxReporter(config));
        this.metricsContext = MetricsContainer.buildMetricsContext(config, kafkaClusterId);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        this.metrics = new Metrics(metricConfig, reporters, (Time)new SystemTime(), this.metricsContext);
        this.isLeaderNode = this.createMetric(METRIC_NAME_MASTER_SLAVE_ROLE, "1.0 indicates the node is the active leader in the cluster and is the node where all register schema and config update requests are served.", (MeasurableStat)new Value());
        this.nodeCount = this.createMetric(METRIC_NAME_NODE_COUNT, "Number of Schema Registry nodes in the cluster", (MeasurableStat)new Value());
        this.apiCallsSuccess = this.createMetric(METRIC_NAME_API_SUCCESS_COUNT, "Number of successful API calls", (MeasurableStat)new CumulativeCount());
        this.apiCallsFailure = this.createMetric(METRIC_NAME_API_FAILURE_COUNT, "Number of failed API calls", (MeasurableStat)new CumulativeCount());
        this.customSchemaProviders = this.createMetric(METRIC_NAME_CUSTOM_SCHEMA_PROVIDER, "Number of custom schema providers", (MeasurableStat)new Value());
        this.schemasCreated = this.createMetric(METRIC_NAME_REGISTERED_COUNT, "Number of registered schemas", (MeasurableStat)new CumulativeCount());
        this.schemasDeleted = this.createMetric(METRIC_NAME_DELETED_COUNT, "Number of deleted schemas", (MeasurableStat)new CumulativeCount());
        this.avroSchemasCreated = this.createMetric(METRIC_NAME_AVRO_SCHEMAS_CREATED, "Number of registered Avro schemas", (MeasurableStat)new CumulativeCount());
        this.avroSchemasDeleted = this.createMetric(METRIC_NAME_AVRO_SCHEMAS_DELETED, "Number of deleted Avro schemas", (MeasurableStat)new CumulativeCount());
        this.jsonSchemasCreated = this.createMetric(METRIC_NAME_JSON_SCHEMAS_CREATED, "Number of registered JSON schemas", (MeasurableStat)new CumulativeCount());
        this.jsonSchemasDeleted = this.createMetric(METRIC_NAME_JSON_SCHEMAS_DELETED, "Number of deleted JSON schemas", (MeasurableStat)new CumulativeCount());
        this.protobufSchemasCreated = this.createMetric(METRIC_NAME_PB_SCHEMAS_CREATED, "Number of registered Protobuf schemas", (MeasurableStat)new CumulativeCount());
        this.protobufSchemasDeleted = this.createMetric(METRIC_NAME_PB_SCHEMAS_DELETED, "Number of deleted Protobuf schemas", (MeasurableStat)new CumulativeCount());
        this.leaderInitializationLatency = this.createMetric(METRIC_LEADER_INITIALIZATION_LATENCY, "Time spent initializing the leader's kafka store", (MeasurableStat)new Value());
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Map<String, String> getMetricsTags() {
        return this.configuredTags;
    }

    public MetricsContext getMetricsContext() {
        return this.metricsContext;
    }

    private static MetricsReporter getJmxReporter(SchemaRegistryConfig config) {
        JmxReporter reporter = new JmxReporter();
        reporter.configure(config.originals());
        return reporter;
    }

    private SchemaRegistryMetric createMetric(String name, String metricDescription, MeasurableStat stat) {
        return this.createMetric(name, name, name, metricDescription, stat);
    }

    private SchemaRegistryMetric createMetric(String sensorName, String metricName, String metricGroup, String metricDescription, MeasurableStat stat) {
        MetricName mn = new MetricName(metricName, metricGroup, metricDescription, this.configuredTags);
        return new SchemaRegistryMetric(this.metrics, sensorName, mn, stat);
    }

    public SchemaRegistryMetric getNodeCountMetric() {
        return this.nodeCount;
    }

    public SchemaRegistryMetric getLeaderNode() {
        return this.isLeaderNode;
    }

    public SchemaRegistryMetric getApiCallsSuccess() {
        return this.apiCallsSuccess;
    }

    public SchemaRegistryMetric getApiCallsFailure() {
        return this.apiCallsFailure;
    }

    public SchemaRegistryMetric getCustomSchemaProviderCount() {
        return this.customSchemaProviders;
    }

    public SchemaRegistryMetric getSchemasCreated() {
        return this.schemasCreated;
    }

    public SchemaRegistryMetric getSchemasCreated(String type) {
        return this.getSchemaTypeMetric(type, true);
    }

    public SchemaRegistryMetric getSchemasDeleted() {
        return this.schemasDeleted;
    }

    public SchemaRegistryMetric getSchemasDeleted(String type) {
        return this.getSchemaTypeMetric(type, false);
    }

    private SchemaRegistryMetric getSchemaTypeMetric(String type, boolean isRegister) {
        switch (type) {
            case "AVRO": {
                return isRegister ? this.avroSchemasCreated : this.avroSchemasDeleted;
            }
            case "JSON": {
                return isRegister ? this.jsonSchemasCreated : this.jsonSchemasDeleted;
            }
            case "PROTOBUF": {
                return isRegister ? this.protobufSchemasCreated : this.protobufSchemasDeleted;
            }
        }
        return null;
    }

    public SchemaRegistryMetric getLeaderInitializationLatencyMetric() {
        return this.leaderInitializationLatency;
    }

    private static MetricsContext buildMetricsContext(SchemaRegistryConfig config, String kafkaClusterId) {
        String srGroupId = config.getString("schema.registry.group.id");
        Map metadata = config.originalsWithPrefix("metrics.context.");
        metadata.put(RESOURCE_LABEL_KAFKA_CLUSTER_ID, kafkaClusterId);
        metadata.put("resource.cluster.id", srGroupId);
        metadata.put("resource.group.id", srGroupId);
        metadata.put("resource.type", "schema_registry");
        metadata.put("resource.version", AppInfoParser.getVersion());
        metadata.put("resource.commit.id", AppInfoParser.getCommitId());
        return new KafkaMetricsContext(JMX_PREFIX, metadata);
    }
}

