/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.tools;

import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.io.IOException;
import java.util.Collections;

public class SchemaRegistryPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSchemas;
    long targetSchemasPerSec;
    String baseUrl;
    RestService restService;
    String subject;
    String schemaType;
    long registeredSchemas = 0L;
    long successfullyRegisteredSchemas = 0L;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SchemaRegistryPerformance.class.getName() + " schema_registry_url subject num_schemas target_schemas_per_sec schema_type");
            System.exit(1);
        }
        String baseUrl = args[0];
        String subject = args[1];
        int numSchemas = Integer.parseInt(args[2]);
        int targetSchemasPerSec = Integer.parseInt(args[3]);
        String schemaType = args[4];
        SchemaRegistryPerformance perf = new SchemaRegistryPerformance(baseUrl, subject, numSchemas, targetSchemasPerSec, schemaType);
        perf.init();
        perf.run(targetSchemasPerSec);
        perf.close();
    }

    public SchemaRegistryPerformance(String baseUrl, String subject, long numSchemas, long targetSchemasPerSec, String schemaType) {
        super(numSchemas);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.subject = subject;
        this.schemaType = schemaType;
        this.targetRegisteredSchemas = numSchemas;
        this.targetSchemasPerSec = targetSchemasPerSec;
    }

    protected void init() throws Exception {
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(CompatibilityLevel.NONE.name);
        this.restService.updateConfig(request, null);
    }

    public static String makeSchema(String schemaType, long num) {
        String schemaString;
        switch (schemaType) {
            case "AVRO": {
                schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
                break;
            }
            case "JSON": {
                schemaString = "{\"type\":\"object\",\"properties\":{\"f" + num + "\":{\"type\":\"string\"}}}";
                break;
            }
            case "PROTOBUF": {
                schemaString = "message Foo { required string f" + num + " = 1; }";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schema type " + schemaType);
            }
        }
        return schemaString;
    }

    public static ParsedSchema makeParsedSchema(String schemaType, long num) {
        AvroSchema parsedSchema;
        String schema = SchemaRegistryPerformance.makeSchema(schemaType, num);
        switch (schemaType) {
            case "AVRO": {
                parsedSchema = new AvroSchema(schema);
                break;
            }
            case "JSON": {
                parsedSchema = new JsonSchema(schema);
                break;
            }
            case "PROTOBUF": {
                parsedSchema = new ProtobufSchema(schema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schema type " + schemaType);
            }
        }
        return parsedSchema;
    }

    protected void doIteration(PerformanceStats.Callback cb) {
        String schema = SchemaRegistryPerformance.makeSchema(this.schemaType, this.registeredSchemas);
        try {
            this.restService.registerSchema(schema, this.schemaType, Collections.emptyList(), this.subject);
            ++this.successfullyRegisteredSchemas;
        }
        catch (IOException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        ++this.registeredSchemas;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSchemas / (double)this.targetRegisteredSchemas < 0.99) {
            throw new RuntimeException("Too many schema registration errors: " + this.successfullyRegisteredSchemas + " registered successfully out of " + this.targetRegisteredSchemas + " attempted");
        }
    }

    protected boolean finished(int iteration) {
        return this.targetRegisteredSchemas == this.registeredSchemas;
    }

    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSchemasPerSec;
    }
}

