/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage.encoder;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.encoder.KeysetWrapper;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class KeysetWrapperDeserializer
implements Deserializer<KeysetWrapper> {
    private Aead aead;
    private Aead oldAead;

    public KeysetWrapperDeserializer(SchemaRegistryConfig config) {
        try {
            String secret = MetadataEncoderService.encoderSecret(config);
            this.aead = MetadataEncoderService.getPrimitive(secret);
            String oldSecret = MetadataEncoderService.encoderOldSecret(config);
            if (oldSecret != null) {
                this.oldAead = MetadataEncoderService.getPrimitive(oldSecret);
            }
        }
        catch (GeneralSecurityException e) {
            throw new ConfigException("Error while configuring KeysetWrapperDeserializer", (Object)e);
        }
    }

    public KeysetWrapper deserialize(String topic, byte[] key) throws SerializationException {
        try {
            KeysetHandle keysetHandle = KeysetHandle.read((KeysetReader)JsonKeysetReader.withBytes((byte[])key), (Aead)this.aead);
            return new KeysetWrapper(keysetHandle, false);
        }
        catch (IOException | GeneralSecurityException e) {
            if (this.oldAead == null) {
                throw new SerializationException("Error while deserializing KeysetWrapper", (Throwable)e);
            }
            try {
                KeysetHandle keysetHandle = KeysetHandle.read((KeysetReader)JsonKeysetReader.withBytes((byte[])key), (Aead)this.oldAead);
                return new KeysetWrapper(keysetHandle, true);
            }
            catch (IOException | GeneralSecurityException e2) {
                throw new SerializationException("Error while deserializing KeysetWrapper", (Throwable)e2);
            }
        }
    }
}

