/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

@PreMatching
@Priority(value=4100)
public class AliasFilter
implements ContainerRequestFilter {
    private final KafkaSchemaRegistry schemaRegistry;

    public AliasFilter(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath(false);
        UriBuilder builder = requestContext.getUriInfo().getRequestUriBuilder();
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters(false);
        URI uri = this.modifyUri(builder, path, (MultivaluedMap<String, String>)queryParams);
        requestContext.setRequestUri(uri);
    }

    @VisibleForTesting
    URI modifyUri(UriBuilder builder, String path, MultivaluedMap<String, String> queryParams) {
        String modifiedPath = this.modifyUriPath(path);
        builder.replacePath(modifiedPath);
        this.replaceQueryParams(builder, modifiedPath, queryParams);
        return builder.build(new Object[0]);
    }

    @VisibleForTesting
    String modifyUriPath(String path) {
        boolean subjectPathFound = false;
        StringBuilder modifiedPath = new StringBuilder();
        for (String uriPathStr : path.split("/")) {
            if (uriPathStr.isEmpty()) continue;
            modifiedPath.append("/");
            String modifiedUriPathStr = uriPathStr;
            if (subjectPathFound) {
                modifiedUriPathStr = this.replaceAlias(uriPathStr);
                subjectPathFound = false;
            }
            if (uriPathStr.equals("subjects")) {
                subjectPathFound = true;
            }
            modifiedPath.append(modifiedUriPathStr);
        }
        if (path.endsWith("/")) {
            modifiedPath.append("/");
        }
        return modifiedPath.toString();
    }

    private void replaceQueryParams(UriBuilder builder, String path, MultivaluedMap<String, String> queryParams) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("schemas/ids")) {
            String subject = (String)queryParams.getFirst((Object)"subject");
            if (subject == null) {
                subject = "";
            }
            builder.replaceQueryParam("subject", new Object[]{this.replaceAlias(subject)});
        }
    }

    private String replaceAlias(String subject) {
        if (subject.isEmpty()) {
            return subject;
        }
        Config config = null;
        try {
            config = this.schemaRegistry.getConfig(URLDecoder.decode(subject, "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config == null) {
            return subject;
        }
        String alias = config.getAlias();
        return alias != null && !alias.isEmpty() ? alias : subject;
    }
}

