/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreMessageHandler
implements SchemaUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreMessageHandler.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache;
    private IdGenerator idGenerator;

    public KafkaStoreMessageHandler(KafkaSchemaRegistry schemaRegistry, LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache, IdGenerator idGenerator) {
        this.schemaRegistry = schemaRegistry;
        this.lookupCache = lookupCache;
        this.idGenerator = idGenerator;
    }

    @Override
    public boolean validateUpdate(SchemaRegistryKey key, SchemaRegistryValue value, TopicPartition tp, long offset, long timestamp) {
        SchemaValue schemaObj;
        if (key.getKeyType() == SchemaRegistryKeyType.SCHEMA && (schemaObj = (SchemaValue)value) != null) {
            try {
                SchemaValue oldSchema;
                SchemaKey oldKey = this.lookupCache.schemaKeyById(schemaObj.getId());
                if (oldKey != null && (oldSchema = (SchemaValue)this.lookupCache.get(oldKey)) != null && !oldSchema.getSchema().equals(schemaObj.getSchema())) {
                    log.error("Found a schema with duplicate ID {}.  This schema will not be registered since a schema already exists with this ID.", (Object)schemaObj.getId());
                    return false;
                }
            }
            catch (StoreException e) {
                log.error("Error while retrieving schema", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        if (key.getKeyType() == SchemaRegistryKeyType.SCHEMA) {
            this.handleSchemaUpdate((SchemaKey)key, (SchemaValue)value, (SchemaValue)oldValue);
        } else if (value != null) {
            if (key.getKeyType() == SchemaRegistryKeyType.DELETE_SUBJECT) {
                this.handleDeleteSubject((DeleteSubjectValue)value);
            } else if (key.getKeyType() == SchemaRegistryKeyType.CLEAR_SUBJECT) {
                this.handleClearSubject((ClearSubjectValue)value);
            }
        }
    }

    private void handleDeleteSubject(DeleteSubjectValue deleteSubjectValue) {
        String subject = deleteSubjectValue.getSubject();
        Integer deleteTillVersion = deleteSubjectValue.getVersion();
        for (int version = 1; version <= deleteTillVersion; ++version) {
            try {
                SchemaKey schemaKey = new SchemaKey(subject, version);
                SchemaValue schemaValue = (SchemaValue)this.lookupCache.get(schemaKey);
                if (schemaValue == null) continue;
                schemaValue.setDeleted(true);
                this.lookupCache.put(schemaKey, schemaValue);
                this.lookupCache.schemaDeleted(schemaKey, schemaValue);
                continue;
            }
            catch (StoreException e) {
                log.error("Failed to delete subject {} in the local cache", (Object)subject, (Object)e);
            }
        }
    }

    private void handleClearSubject(ClearSubjectValue clearSubjectValue) {
        String subject = clearSubjectValue.getSubject();
        try {
            this.lookupCache.clearSubjects(subject);
        }
        catch (StoreException e) {
            log.error("Failed to clear subject {} in the local cache", (Object)subject, (Object)e);
        }
    }

    private void handleSchemaUpdate(SchemaKey schemaKey, SchemaValue schemaValue, SchemaValue oldSchemaValue) {
        MetricsContainer metricsContainer = this.schemaRegistry.getMetricsContainer();
        if (schemaValue != null) {
            this.idGenerator.schemaRegistered(schemaKey, schemaValue);
            if (schemaValue.isDeleted()) {
                this.lookupCache.schemaDeleted(schemaKey, schemaValue);
                KafkaStoreMessageHandler.updateMetrics(metricsContainer.getSchemasDeleted(), metricsContainer.getSchemasDeleted(KafkaStoreMessageHandler.getSchemaType(schemaValue)));
            } else {
                this.lookupCache.schemaRegistered(schemaKey, schemaValue);
                KafkaStoreMessageHandler.updateMetrics(metricsContainer.getSchemasCreated(), metricsContainer.getSchemasCreated(KafkaStoreMessageHandler.getSchemaType(schemaValue)));
            }
        } else {
            this.lookupCache.schemaTombstoned(schemaKey, oldSchemaValue);
        }
    }

    private static String getSchemaType(SchemaValue schemaValue) {
        return schemaValue.getSchemaType() == null ? "AVRO" : schemaValue.getSchemaType();
    }

    private static void updateMetrics(SchemaRegistryMetric total, SchemaRegistryMetric perType) {
        total.increment();
        if (perType != null) {
            perType.increment();
        }
    }
}

