/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.rest.Application;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;

public class MetricsContainer {
    public static final String JMX_PREFIX = "kafka.schema.registry";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_KAFKA_CLUSTER_ID = "resource.kafka.cluster.id";
    public static final String RESOURCE_LABEL_CLUSTER_ID = "resource.cluster.id";
    public static final String RESOURCE_LABEL_GROUP_ID = "resource.group.id";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    private final Metrics metrics;
    private final Map<String, String> configuredTags;
    private final SchemaRegistryMetric isLeaderNode;
    private final SchemaRegistryMetric nodeCount;
    private final SchemaRegistryMetric schemasCreated;
    private final SchemaRegistryMetric schemasDeleted;
    private final SchemaRegistryMetric customSchemaProviders;
    private final SchemaRegistryMetric apiCallsSuccess;
    private final SchemaRegistryMetric apiCallsFailure;
    private final SchemaRegistryMetric avroSchemasCreated;
    private final SchemaRegistryMetric jsonSchemasCreated;
    private final SchemaRegistryMetric protobufSchemasCreated;
    private final SchemaRegistryMetric avroSchemasDeleted;
    private final SchemaRegistryMetric jsonSchemasDeleted;
    private final SchemaRegistryMetric protobufSchemasDeleted;
    private final MetricsContext metricsContext;

    public MetricsContainer(SchemaRegistryConfig config, String kafkaClusterId) {
        this.configuredTags = Application.parseListToMap((List)config.getList("metrics.tag.map"));
        List reporters = config.getConfiguredInstances(config.getList("metric.reporters"), MetricsReporter.class, Collections.singletonMap("kafkastore.topic", config.getString("kafkastore.topic")));
        reporters.add(MetricsContainer.getJmxReporter(config));
        this.metricsContext = MetricsContainer.getMetricsContext(config, kafkaClusterId);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        this.metrics = new Metrics(metricConfig, reporters, (Time)new SystemTime(), this.metricsContext);
        this.isLeaderNode = this.createMetric("master-slave-role", "1.0 indicates the node is the active leader in the cluster and is the node where all register schema and config update requests are served.");
        this.nodeCount = this.createMetric("node-count", "Number of Schema Registry nodes in the cluster");
        this.apiCallsSuccess = this.createMetric("api-success-count", "Number of successful API calls");
        this.apiCallsFailure = this.createMetric("api-failure-count", "Number of failed API calls");
        this.customSchemaProviders = this.createMetric("custom-schema-provider-count", "Number of custom schema providers");
        this.schemasCreated = this.createMetric("registered-count", "Number of registered schemas");
        this.schemasDeleted = this.createMetric("deleted-count", "Number of deleted schemas");
        this.avroSchemasCreated = this.createMetric("avro-schemas-created", "Number of registered Avro schemas");
        this.avroSchemasDeleted = this.createMetric("avro-schemas-deleted", "Number of deleted Avro schemas");
        this.jsonSchemasCreated = this.createMetric("json-schemas-created", "Number of registered JSON schemas");
        this.jsonSchemasDeleted = this.createMetric("json-schemas-deleted", "Number of deleted JSON schemas");
        this.protobufSchemasCreated = this.createMetric("protobuf-schemas-created", "Number of registered Protobuf schemas");
        this.protobufSchemasDeleted = this.createMetric("protobuf-schemas-deleted", "Number of deleted Protobuf schemas");
    }

    private static MetricsReporter getJmxReporter(SchemaRegistryConfig config) {
        JmxReporter reporter = new JmxReporter();
        reporter.configure(config.originals());
        return reporter;
    }

    private SchemaRegistryMetric createMetric(String name, String metricDescription) {
        return this.createMetric(name, name, name, metricDescription);
    }

    private SchemaRegistryMetric createMetric(String sensorName, String metricName, String metricGroup, String metricDescription) {
        MetricName mn = new MetricName(metricName, metricGroup, metricDescription, this.configuredTags);
        return new SchemaRegistryMetric(this.metrics, sensorName, mn);
    }

    public SchemaRegistryMetric getNodeCountMetric() {
        return this.nodeCount;
    }

    public SchemaRegistryMetric getLeaderNode() {
        return this.isLeaderNode;
    }

    public SchemaRegistryMetric getApiCallsSuccess() {
        return this.apiCallsSuccess;
    }

    public SchemaRegistryMetric getApiCallsFailure() {
        return this.apiCallsFailure;
    }

    public SchemaRegistryMetric getCustomSchemaProviderCount() {
        return this.customSchemaProviders;
    }

    public SchemaRegistryMetric getSchemasCreated() {
        return this.schemasCreated;
    }

    public SchemaRegistryMetric getSchemasCreated(String type) {
        return this.getSchemaTypeMetric(type, true);
    }

    public SchemaRegistryMetric getSchemasDeleted() {
        return this.schemasDeleted;
    }

    public SchemaRegistryMetric getSchemasDeleted(String type) {
        return this.getSchemaTypeMetric(type, false);
    }

    private SchemaRegistryMetric getSchemaTypeMetric(String type, boolean isRegister) {
        switch (type) {
            case "AVRO": {
                return isRegister ? this.avroSchemasCreated : this.avroSchemasDeleted;
            }
            case "JSON": {
                return isRegister ? this.jsonSchemasCreated : this.jsonSchemasDeleted;
            }
            case "PROTOBUF": {
                return isRegister ? this.protobufSchemasCreated : this.protobufSchemasDeleted;
            }
        }
        return null;
    }

    private static MetricsContext getMetricsContext(SchemaRegistryConfig config, String kafkaClusterId) {
        String srGroupId = config.getString("schema.registry.group.id");
        Map metadata = config.originalsWithPrefix("metrics.context.");
        metadata.put(RESOURCE_LABEL_KAFKA_CLUSTER_ID, kafkaClusterId);
        metadata.put(RESOURCE_LABEL_CLUSTER_ID, srGroupId);
        metadata.put(RESOURCE_LABEL_GROUP_ID, srGroupId);
        metadata.put(RESOURCE_LABEL_TYPE, "schema_registry");
        metadata.put(RESOURCE_LABEL_VERSION, AppInfoParser.getVersion());
        metadata.put(RESOURCE_LABEL_COMMIT_ID, AppInfoParser.getCommitId());
        return new KafkaMetricsContext(JMX_PREFIX, metadata);
    }
}

