/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class MD5 {
    private final byte[] md5;

    public MD5(byte[] md5) {
        if (md5 == null) {
            throw new IllegalArgumentException("Tried to instantiate MD5 object with null byte array.");
        }
        if (md5.length != 16) {
            throw new IllegalArgumentException("Tried to instantiate MD5 object with invalid byte array.");
        }
        this.md5 = md5;
    }

    public static MD5 ofString(String str, List<SchemaReference> references) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            if (references != null) {
                for (SchemaReference reference : references) {
                    md.update(reference.getName().getBytes(StandardCharsets.UTF_8));
                    md.update(reference.getSubject().getBytes(StandardCharsets.UTF_8));
                    md.update(ByteBuffer.allocate(4).putInt(reference.getVersion()).array());
                }
            }
            return new MD5(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.md5);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof MD5)) {
            return false;
        }
        MD5 otherMd5 = (MD5)o;
        return Arrays.equals(this.md5, otherMd5.md5);
    }
}

