/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import com.google.inject.internal.util.Preconditions;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test-compatibility")
public class TestCompatibilitySchemaRegistryMojo
extends SchemaRegistryMojo {
    @Parameter(required=true)
    Map<String, File> subjects = new HashMap<String, File>();
    Map<String, Boolean> schemaCompatibility;
    @Parameter(required=false)
    List<String> imports;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Schema> subjectToSchemaLookup = this.loadSchemas(this.subjects);
        this.schemaCompatibility = new LinkedHashMap<String, Boolean>();
        int errorCount = 0;
        for (Map.Entry<String, Schema> kvp : subjectToSchemaLookup.entrySet()) {
            try {
                boolean compatible;
                File schemaPath = this.subjects.get(kvp.getKey());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Calling register('%s', '%s')", kvp.getKey(), kvp.getValue().toString(true)));
                }
                if (compatible = this.client().testCompatibility(kvp.getKey(), kvp.getValue())) {
                    this.getLog().info((CharSequence)String.format("Schema %s is compatible with subject(%s)", schemaPath, kvp.getKey()));
                } else {
                    this.getLog().error((CharSequence)String.format("Schema %s is not compatible with subject(%s)", schemaPath, kvp.getKey()));
                    ++errorCount;
                }
                this.schemaCompatibility.put(kvp.getKey(), compatible);
            }
            catch (RestClientException | IOException e) {
                this.getLog().error((CharSequence)String.format("Exception thrown while registering subject(%s)", kvp.getKey()), e);
            }
        }
        Preconditions.checkState((errorCount == 0 ? 1 : 0) != 0, (Object)"One or more schema was found to be incompatible with the current version.");
    }

    @Override
    protected Schema.Parser newParser() {
        if (this.imports == null || this.imports.isEmpty()) {
            return super.newParser();
        }
        return this.parserWithDependencies(this.imports);
    }
}

