/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.testutil;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;

public final class MockSchemaRegistry {
    private static final String MOCK_URL_PREFIX = "mock://";
    private static final Map<String, SchemaRegistryClient> SCOPED_CLIENTS = new HashMap<String, SchemaRegistryClient>();

    private MockSchemaRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient());
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope, List<SchemaProvider> providers) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient(providers));
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(List<String> scopes, List<SchemaProvider> providers) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            for (String scope : scopes) {
                if (SCOPED_CLIENTS.containsKey(scope)) continue;
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient(providers));
            }
        }
        return SCOPED_CLIENTS.get(scopes.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.remove(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.clear();
        }
    }

    public static String validateAndMaybeGetMockScope(List<String> urls) {
        LinkedList<String> mockScopes = new LinkedList<String>();
        for (String url : urls) {
            if (!url.startsWith(MOCK_URL_PREFIX)) continue;
            mockScopes.add(url.substring(MOCK_URL_PREFIX.length()));
        }
        if (mockScopes.isEmpty()) {
            return null;
        }
        if (mockScopes.size() > 1) {
            throw new ConfigException("Only one mock scope is permitted for 'schema.registry.url'. Got: " + String.valueOf(urls));
        }
        if (urls.size() > mockScopes.size()) {
            throw new ConfigException("Cannot mix mock and real urls for 'schema.registry.url'. Got: " + String.valueOf(urls));
        }
        return (String)mockScopes.get(0);
    }

    public static List<String> validateAndMaybeGetMockScope(String baseUrls) {
        LinkedList<String> mockScopes = new LinkedList<String>();
        List<String> urls = MockSchemaRegistry.parseBaseUrl(baseUrls);
        for (String url : urls) {
            if (!url.startsWith(MOCK_URL_PREFIX)) continue;
            mockScopes.add(url.substring(MOCK_URL_PREFIX.length()));
        }
        if (mockScopes.isEmpty()) {
            return null;
        }
        if (urls.size() > mockScopes.size()) {
            throw new ConfigException("Cannot mix mock and real urls for 'schema.registry.url'. Got: " + String.valueOf(urls));
        }
        return mockScopes;
    }

    private static List<String> parseBaseUrl(String baseUrls) {
        List<String> urls = Arrays.asList(baseUrls.split("\\s*,\\s*"));
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Missing required schema registry url list");
        }
        return urls;
    }
}

