/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import org.junit.Assert;
import org.junit.Test;

public class QualifiedSubjectTest {
    @Test
    public void testSimpleContextSubject() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:.ctx1:subject1");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"subject1", (Object)qs.getSubject());
    }

    @Test
    public void testSubjectWithColon() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:.ctx1:sub:ject1");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"sub:ject1", (Object)qs.getSubject());
    }

    @Test
    public void testSubjectWithQuote() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:.ctx1:'sub''ject1'");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"'sub''ject1'", (Object)qs.getSubject());
    }

    @Test
    public void testContextWildcard() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:*:");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)"*", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testInvalidContextSubject() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:ctx1:subject1");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)":ctx1:subject1", (Object)qs.getSubject());
    }

    @Test
    public void testMissingAll() {
        QualifiedSubject qs = new QualifiedSubject("default", "");
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testSubjectOnly() {
        QualifiedSubject qs = new QualifiedSubject("default", "subject1");
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"subject1", (Object)qs.getSubject());
    }

    @Test
    public void testContextOnly() {
        QualifiedSubject qs = new QualifiedSubject("default", ":.ctx1:");
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testMissingTenant() {
        QualifiedSubject qs = new QualifiedSubject("default", ":.ctx1:subject1");
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"subject1", (Object)qs.getSubject());
    }

    @Test
    public void testDefaultNull() {
        QualifiedSubject qs = new QualifiedSubject("default", null);
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testAllNull() {
        QualifiedSubject qs = new QualifiedSubject(null, null);
        Assert.assertEquals((Object)"default", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testTenantOnly() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_::");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"::", (Object)qs.getSubject());
    }

    @Test
    public void testMissingContext() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_::subject1");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"::subject1", (Object)qs.getSubject());
    }

    @Test
    public void testQualifiedContext() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:.ctx1:");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testQualifiedContextMissingLastColon() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_:.ctx1");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".ctx1", (Object)qs.getContext());
        Assert.assertEquals((Object)"", (Object)qs.getSubject());
    }

    @Test
    public void testTenantWildcard() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", "tenant1_*");
        Assert.assertEquals((Object)"tenant1", (Object)qs.getTenant());
        Assert.assertEquals((Object)".", (Object)qs.getContext());
        Assert.assertEquals((Object)"*", (Object)qs.getSubject());
    }

    @Test
    public void testToString() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", ".ctx1", "subject1");
        Assert.assertEquals((Object)"tenant1_:.ctx1:subject1", (Object)qs.toString());
    }

    @Test
    public void testToStringMissingAll() {
        QualifiedSubject qs = new QualifiedSubject(null, null, null);
        Assert.assertEquals((Object)"", (Object)qs.toString());
    }

    @Test
    public void testToStringSubjectOnly() {
        QualifiedSubject qs = new QualifiedSubject(null, null, "subject1");
        Assert.assertEquals((Object)"subject1", (Object)qs.toString());
    }

    @Test
    public void testToStringContextOnly() {
        QualifiedSubject qs = new QualifiedSubject(null, ".ctx1", null);
        Assert.assertEquals((Object)":.ctx1:", (Object)qs.toString());
    }

    @Test
    public void testToStringMissingTenant() {
        QualifiedSubject qs = new QualifiedSubject(null, ".ctx1", "subject1");
        Assert.assertEquals((Object)":.ctx1:subject1", (Object)qs.toString());
    }

    @Test
    public void testToStringTenantOnly() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", null, null);
        Assert.assertEquals((Object)"tenant1_", (Object)qs.toString());
    }

    @Test
    public void testToStringMissingContext() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", null, "subject1");
        Assert.assertEquals((Object)"tenant1_subject1", (Object)qs.toString());
    }

    @Test
    public void testToStringQualifiedContext() {
        QualifiedSubject qs = new QualifiedSubject("tenant1", ".ctx1", null);
        Assert.assertEquals((Object)"tenant1_:.ctx1:", (Object)qs.toString());
    }

    @Test
    public void testSubjectValidation() {
        Assert.assertTrue((boolean)QualifiedSubject.isValidSubject((String)"default", (String)"foo"));
        Assert.assertFalse((boolean)QualifiedSubject.isValidSubject((String)"default", null));
        Assert.assertTrue((boolean)QualifiedSubject.isValidSubject((String)"default", (String)""));
        Assert.assertFalse((boolean)QualifiedSubject.isValidSubject((String)"default", (String)String.valueOf('\u001f')));
        Assert.assertTrue((boolean)QualifiedSubject.isValidSubject((String)"default", (String)"  "));
        Assert.assertFalse((boolean)QualifiedSubject.isValidSubject((String)"default", (String)"__GLOBAL"));
        Assert.assertFalse((boolean)QualifiedSubject.isValidSubject((String)"default", (String)"__EMPTY"));
    }
}

