/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.SaslOauthCredentialProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SaslOauthCredentialProviderTest {
    @Mock
    CachedOauthTokenRetriever tokenRetriever;
    @InjectMocks
    BearerAuthCredentialProvider oAuthCredentialProvider = new SaslOauthCredentialProvider();
    private String tokenString = "dummy-token";
    private Map<String, Object> clientConfig = new HashMap<String, Object>();

    @Before
    public void InitialiaseSaslConfig() {
        this.clientConfig.put("sasl.jaas.config", new Password("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required clientId=\"0oa3tq39ol3OLrnQj4x4\" scope='test' clientSecret='mysecret123' extension_logicalCluster='LKC_OF_KAFKA_CLUSTER' extension_identityPoolId='SASL_IDENTITY_POOL_ID';"));
        this.clientConfig.put("bearer.auth.logical.cluster", "lsrc-dummy");
        this.clientConfig.put("sasl.oauthbearer.token.endpoint.url", "https://dev-531534.okta.com/oauth2/default/v1/token");
    }

    @Test
    public void TestGetBearerToken() throws MalformedURLException {
        Mockito.when((Object)this.tokenRetriever.getToken()).thenReturn((Object)this.tokenString);
        Assert.assertEquals((Object)this.tokenString, (Object)this.oAuthCredentialProvider.getBearerToken(new URL("https://dummy.com")));
    }

    @Test
    public void TestkafkaConfigInheritance() {
        HashMap<String, Object> clientConfig = new HashMap<String, Object>(this.clientConfig);
        this.oAuthCredentialProvider.configure(clientConfig);
        Assert.assertEquals((Object)"SASL_IDENTITY_POOL_ID", (Object)this.oAuthCredentialProvider.getTargetIdentityPoolId());
    }

    @Test
    public void TestBearerConfigHigherPrecedence() {
        HashMap<String, Object> clientConfig = new HashMap<String, Object>(this.clientConfig);
        clientConfig.put("bearer.auth.identity.pool.id", "BEARER_IDENTITY_POOL_ID");
        this.oAuthCredentialProvider.configure(clientConfig);
        Assert.assertEquals((Object)"BEARER_IDENTITY_POOL_ID", (Object)this.oAuthCredentialProvider.getTargetIdentityPoolId());
    }
}

