/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthCredentialProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OauthCredentialProviderTest {
    @Mock
    CachedOauthTokenRetriever tokenRetriever;
    @InjectMocks
    OauthCredentialProvider oAuthCredentialProvider = new OauthCredentialProvider();
    private String tokenString = "dummy-token";
    private Map<String, Object> CONFIG_MAP;

    @Before
    public void InitializeConfigMap() {
        this.CONFIG_MAP = new HashMap<String, Object>();
        this.CONFIG_MAP.put("bearer.auth.logical.cluster", "lsrc-dummy");
        this.CONFIG_MAP.put("bearer.auth.identity.pool.id", "my-pool-id");
        this.CONFIG_MAP.put("bearer.auth.scope", "test-scope");
        this.CONFIG_MAP.put("bearer.auth.client.secret", "mysecret");
        this.CONFIG_MAP.put("bearer.auth.client.id", "myid");
        this.CONFIG_MAP.put("bearer.auth.issuer.endpoint.url", "https://okta.com");
    }

    @Test
    public void TestGetBearerToken() throws MalformedURLException {
        Mockito.when((Object)this.tokenRetriever.getToken()).thenReturn((Object)this.tokenString);
        Assert.assertEquals((Object)this.tokenString, (Object)this.oAuthCredentialProvider.getBearerToken(new URL("https://dummy.com")));
    }

    @Test
    public void TestConfigureInsufficientConfigs() {
        List<String> optionalConfigs = Arrays.asList("bearer.auth.scope", "bearer.auth.scope.claim.name", "bearer.auth.sub.claim.name", "bearer.auth.identity.pool.id", "bearer.auth.logical.cluster");
        for (String missingKey : this.CONFIG_MAP.keySet()) {
            if (optionalConfigs.contains(missingKey)) continue;
            Assert.assertThrows((String)String.format("The OAuth configuration option %s value must be non-null", missingKey), ConfigException.class, () -> this.oAuthCredentialProvider.configure(this.getInsufficentConfigs(missingKey)));
        }
    }

    @Test
    public void testClientSslConfigurations() throws MalformedURLException {
        HashMap<String, Object> CONFIG_WITH_SSL = new HashMap<String, Object>(this.CONFIG_MAP);
        CONFIG_WITH_SSL.put("ssl.truststore.location", "truststore.jks");
        CONFIG_WITH_SSL.put("ssl.truststore.password", "password");
        Assert.assertThrows((String)"Message", KafkaException.class, () -> this.oAuthCredentialProvider.configure(CONFIG_WITH_SSL));
    }

    private Map<String, Object> getInsufficentConfigs(String missingConfig) {
        HashMap<String, Object> insufficentCofigs = new HashMap<String, Object>(this.CONFIG_MAP);
        insufficentCofigs.remove(missingConfig);
        return insufficentCofigs;
    }
}

