/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.basicauth;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.security.basicauth.SaslBasicAuthCredentialProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Test;

public class SaslBasicAuthCredentialProviderTest {
    @Test
    public void testJaasConfigFile() throws IOException {
        File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
        jaasConfigFile.deleteOnExit();
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("KafkaClient { org.apache.kafka.common.security.plain.PlainLoginModule required username=\"user\" password=\"password\";};");
        Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        Configuration.setConfiguration(null);
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        provider.configure(new HashMap());
        Assert.assertEquals((Object)"user:password", (Object)provider.getUserInfo(null));
    }

    @Test
    public void testClientJaasConfigWithPlain() throws IOException {
        HashMap<String, Password> clientConfig = new HashMap<String, Password>();
        clientConfig.put("sasl.jaas.config", new Password("org.apache.kafka.common.security.scram.ScramLoginModule required username=\"user\" password=\"password\";"));
        Configuration.setConfiguration(null);
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        provider.configure(clientConfig);
        Assert.assertEquals((Object)"user:password", (Object)provider.getUserInfo(null));
    }

    @Test
    public void testClientJaasConfigWithScram() throws IOException {
        HashMap<String, Password> clientConfig = new HashMap<String, Password>();
        clientConfig.put("sasl.jaas.config", new Password("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"user\" password=\"password\";"));
        Configuration.setConfiguration(null);
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        provider.configure(clientConfig);
        Assert.assertEquals((Object)"user:password", (Object)provider.getUserInfo(null));
    }

    @Test(expected=ConfigException.class)
    public void testClientJaasConfigWithKerberos() throws IOException {
        HashMap<String, Password> clientConfig = new HashMap<String, Password>();
        clientConfig.put("sasl.jaas.config", new Password("com.sun.security.auth.module.Krb5LoginModule required         useKeyTab=true         storeKey=true          keyTab=\"/etc/security/keytabs/kafka_client.keytab\"         principal=\"kafka-client-1@EXAMPLE.COM\";"));
        Configuration.setConfiguration(null);
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        provider.configure(clientConfig);
    }

    @Test
    public void testGetUpdatedConfigsForJaasUtilWithString() {
        String jaasConfig = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"user\" password=\"password\";";
        ImmutableMap originalMap = ImmutableMap.of((Object)"test-key", (Object)"test-value", (Object)"sasl.jaas.config", (Object)jaasConfig);
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        Map updatedMap = provider.getConfigsForJaasUtil((Map)originalMap);
        Assert.assertNotNull((Object)updatedMap);
        Assert.assertEquals(originalMap.keySet(), updatedMap.keySet());
        Assert.assertTrue((boolean)(updatedMap.get("sasl.jaas.config") instanceof Password));
        Assert.assertEquals((Object)new Password(jaasConfig), updatedMap.get("sasl.jaas.config"));
    }

    @Test
    public void testGetUpdatedConfigsForJaasUtilWithPassword() {
        String jaasConfig = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"user\" password=\"password\";";
        ImmutableMap originalMap = ImmutableMap.of((Object)"test-key", (Object)"test-value", (Object)"sasl.jaas.config", (Object)new Password(jaasConfig));
        SaslBasicAuthCredentialProvider provider = new SaslBasicAuthCredentialProvider();
        Map updatedMap = provider.getConfigsForJaasUtil((Map)originalMap);
        Assert.assertNotNull((Object)updatedMap);
        Assert.assertEquals(originalMap.keySet(), updatedMap.keySet());
        Assert.assertTrue((boolean)(updatedMap.get("sasl.jaas.config") instanceof Password));
        Assert.assertEquals((Object)new Password(jaasConfig), updatedMap.get("sasl.jaas.config"));
    }
}

