/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import junit.framework.TestCase;
import org.junit.Test;

public class RegisterSchemaRequestTest {
    @Test
    public void buildRegisterSchemaRequest() throws Exception {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema("string");
        request.setId(Integer.valueOf(100));
        request.setVersion(Integer.valueOf(10));
        TestCase.assertEquals((String)"{\"version\":10,\"id\":100,\"schema\":\"string\"}", (String)request.toJson());
    }

    @Test
    public void buildRegisterSchemaRequestWithoutId() throws Exception {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema("string");
        request.setVersion(Integer.valueOf(10));
        TestCase.assertEquals((String)"{\"version\":10,\"schema\":\"string\"}", (String)request.toJson());
    }

    @Test
    public void buildRegisterSchemaRequestWithoutVersion() throws Exception {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema("string");
        request.setId(Integer.valueOf(100));
        TestCase.assertEquals((String)"{\"id\":100,\"schema\":\"string\"}", (String)request.toJson());
    }

    @Test
    public void buildRegisterSchemaRequestWithoutIdOrVersion() throws Exception {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema("string");
        TestCase.assertEquals((String)"{\"schema\":\"string\"}", (String)request.toJson());
    }

    @Test
    public void buildRegisterSchemaRequestWithSchemaTypeAvro() throws Exception {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema("string");
        request.setSchemaType("AVRO");
        TestCase.assertEquals((String)"{\"schema\":\"string\"}", (String)request.toJson());
    }
}

