/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import io.confluent.kafka.schemaregistry.client.rest.UriBuilder;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class UriBuilderTest {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @Test
    public void findTemplateNamesInPath() {
        List templateNames = UriBuilder.findNamesInTemplate((String)"https://some.host/{subject}/and/{version}/resource");
        Assert.assertEquals((Object)templateNames, Arrays.asList("{subject}", "{version}"));
    }

    @Test
    public void encodeCommonPathSegmentChars() throws Exception {
        Assert.assertEquals((Object)"%0A", (Object)UriBuilder.UriPercentEncoder.encode((String)"\n", (Charset)UTF8));
        Assert.assertEquals((Object)"%22", (Object)UriBuilder.UriPercentEncoder.encode((String)"\"", (Charset)UTF8));
        Assert.assertEquals((Object)"%25", (Object)UriBuilder.UriPercentEncoder.encode((String)"%", (Charset)UTF8));
        Assert.assertEquals((Object)"%3C", (Object)UriBuilder.UriPercentEncoder.encode((String)"<", (Charset)UTF8));
        Assert.assertEquals((Object)"%3E", (Object)UriBuilder.UriPercentEncoder.encode((String)">", (Charset)UTF8));
        Assert.assertEquals((Object)"%5C", (Object)UriBuilder.UriPercentEncoder.encode((String)"\\", (Charset)UTF8));
        Assert.assertEquals((Object)"%5E", (Object)UriBuilder.UriPercentEncoder.encode((String)"^", (Charset)UTF8));
        Assert.assertEquals((Object)"%60", (Object)UriBuilder.UriPercentEncoder.encode((String)"`", (Charset)UTF8));
        Assert.assertEquals((Object)"%7B", (Object)UriBuilder.UriPercentEncoder.encode((String)"{", (Charset)UTF8));
        Assert.assertEquals((Object)"%7C", (Object)UriBuilder.UriPercentEncoder.encode((String)"|", (Charset)UTF8));
        Assert.assertEquals((Object)"%7D", (Object)UriBuilder.UriPercentEncoder.encode((String)"}", (Charset)UTF8));
        Assert.assertEquals((Object)"%3F", (Object)UriBuilder.UriPercentEncoder.encode((String)"?", (Charset)UTF8));
        Assert.assertEquals((Object)"foo%20bar%3F", (Object)UriBuilder.UriPercentEncoder.encode((String)"foo bar?", (Charset)UTF8));
    }

    @Test
    public void doNotEncodeAllowedPathSegmentChars() throws Exception {
        for (char c : UriBuilder.UriPercentEncoder.CHARS_UNENCODE.toCharArray()) {
            String s = Character.toString(c);
            Assert.assertEquals((Object)s, (Object)UriBuilder.UriPercentEncoder.encode((String)s, (Charset)UTF8));
        }
    }

    @Test
    public void verifyPathSegmentPercentEncodingOfCharactersHandledDifferentlyInLegacyRFCs() throws Exception {
        Assert.assertEquals((Object)"+", (Object)UriBuilder.UriPercentEncoder.encode((String)"+", (Charset)UTF8));
        Assert.assertEquals((Object)"%20", (Object)UriBuilder.UriPercentEncoder.encode((String)" ", (Charset)UTF8));
        Assert.assertEquals((Object)"~", (Object)UriBuilder.UriPercentEncoder.encode((String)"~", (Charset)UTF8));
        Assert.assertEquals((Object)"*", (Object)UriBuilder.UriPercentEncoder.encode((String)"*", (Charset)UTF8));
    }

    @Test
    public void buildPathTemplateParameters() throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/some/site/{part}");
        URI uri = uriBuilder.build(new Object[]{"mypart"});
        Assert.assertEquals((Object)uri, (Object)new URI("/some/site/mypart"));
    }

    @Test
    public void buildEncodedPathTemplateParameters() throws Exception {
        Assert.assertEquals((Object)new URI("/some/site/my%20part"), (Object)UriBuilder.fromPath((String)"/some/site/{part}").build(new Object[]{"my part"}));
        Assert.assertEquals((Object)new URI("/some/site/my_part"), (Object)UriBuilder.fromPath((String)"/some/site/{part}").build(new Object[]{"my_part"}));
        Assert.assertEquals((Object)new URI("/some/site/my%3Cpart/more"), (Object)UriBuilder.fromPath((String)"/some/site/{part}/more").build(new Object[]{"my<part"}));
        Assert.assertEquals((Object)new URI("/some/site/my%2Fpart/more"), (Object)UriBuilder.fromPath((String)"/some/site/{part}/more").build(new Object[]{"my/part"}));
    }

    @Test
    public void buildPathQueryParameters() throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/some/site");
        uriBuilder.queryParam("first", "1");
        uriBuilder.queryParam("second", Integer.valueOf(2));
        Assert.assertEquals((Object)uriBuilder.build(new Object[0]), (Object)new URI("/some/site?first=1&second=2"));
    }

    @Test
    public void testApi() throws Exception {
        String subject = "testTopic";
        int version = 2;
        UriBuilder builder = UriBuilder.fromPath((String)"/subjects/{subject}/versions/{version}").queryParam("deleted", true);
        String path = builder.build(new Object[]{subject, version}).toString();
        Assert.assertEquals((Object)path, (Object)"/subjects/testTopic/versions/2?deleted=true");
    }

    @Test
    public void checkEncodingOfSomeStandardSubjectTopicNames() throws Exception {
        UriBuilder builder = UriBuilder.fromPath((String)"/subjects/{subject}");
        Assert.assertEquals((Object)"/subjects/my1.topic.name", (Object)builder.build(new Object[]{"my1.topic.name"}).toString());
        Assert.assertEquals((Object)"/subjects/another-topic-name", (Object)builder.build(new Object[]{"another-topic-name"}).toString());
        Assert.assertEquals((Object)"/subjects/My_topic_name", (Object)builder.build(new Object[]{"My_topic_name"}).toString());
    }
}

