/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import io.confluent.kafka.schemaregistry.client.rest.RetryExecutor;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;

public class RetryExecutorTest {
    @Test
    public void testRetryExecutor() throws IOException, RestClientException {
        RetryExecutor retryExecutor = new RetryExecutor(3, 0, 0);
        TestCallable testCallable = new TestCallable();
        int result = (Integer)retryExecutor.retry((Callable)testCallable);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testRetryExecutorWithVoid() throws IOException, RestClientException {
        RetryExecutor retryExecutor = new RetryExecutor(3, 0, 0);
        TestVoidCallable testCallable = new TestVoidCallable();
        retryExecutor.retry((Callable)testCallable);
        Assert.assertEquals((long)1L, (long)testCallable.count);
    }

    class TestVoidCallable
    implements Callable<Void> {
        protected int count = 0;

        TestVoidCallable() {
        }

        @Override
        public Void call() throws RestClientException {
            ++this.count;
            return null;
        }
    }

    class TestCallable
    implements Callable<Integer> {
        private int count = 0;

        TestCallable() {
        }

        @Override
        public Integer call() throws RestClientException {
            if (this.count < 3) {
                ++this.count;
                throw new RestClientException("test", 500, 50001);
            }
            return this.count;
        }
    }
}

