/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import io.confluent.kafka.schemaregistry.client.rest.RetryExecutor;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class RetryExecutorBackoffTest {
    @Parameterized.Parameter
    public TestCase testCase;
    @Mock
    private Random mockRandom = (Random)Mockito.mock(Random.class, (MockSettings)Mockito.withSettings().withoutAnnotations());

    @Parameterized.Parameters
    public static Collection<TestCase> parameters() throws Exception {
        return Arrays.asList(new TestCase().retriesAttempted(0).expectedMaxDelay(Duration.ofMillis(1000L)).expectedMedDelay(Duration.ofMillis(500L)).expectedMinDelay(Duration.ofMillis(1L)), new TestCase().retriesAttempted(1).expectedMaxDelay(Duration.ofMillis(2000L)).expectedMedDelay(Duration.ofMillis(1000L)).expectedMinDelay(Duration.ofMillis(1L)), new TestCase().retriesAttempted(2).expectedMaxDelay(Duration.ofMillis(4000L)).expectedMedDelay(Duration.ofMillis(2000L)).expectedMinDelay(Duration.ofMillis(1L)), new TestCase().retriesAttempted(3).expectedMaxDelay(Duration.ofMillis(8000L)).expectedMedDelay(Duration.ofMillis(4000L)).expectedMinDelay(Duration.ofMillis(1L)), new TestCase().retriesAttempted(4).expectedMaxDelay(Duration.ofMillis(16000L)).expectedMedDelay(Duration.ofMillis(8000L)).expectedMinDelay(Duration.ofMillis(1L)), new TestCase().retriesAttempted(100).expectedMaxDelay(Duration.ofSeconds(20L)).expectedMedDelay(Duration.ofSeconds(10L)).expectedMinDelay(Duration.ofMillis(1L)));
    }

    @Before
    public void setUp() throws Exception {
        this.testCase.retryExecutor = new RetryExecutor(3, 1000, 20000, this.mockRandom);
    }

    @Test
    public void testMaxDelay() {
        this.mockMaxRandom();
        RetryExecutorBackoffTest.test(this.testCase.retryExecutor, this.testCase.retriesAttempted, this.testCase.expectedMaxDelay);
    }

    @Test
    public void testMedDelay() {
        this.mockMediumRandom();
        RetryExecutorBackoffTest.test(this.testCase.retryExecutor, this.testCase.retriesAttempted, this.testCase.expectedMedDelay);
    }

    @Test
    public void testMinDelay() {
        this.mockMinRandom();
        RetryExecutorBackoffTest.test(this.testCase.retryExecutor, this.testCase.retriesAttempted, this.testCase.expectedMinDelay);
    }

    private static void test(RetryExecutor retryExecutor, int retriesAttempted, Duration expectedDelay) {
        Duration computedDelay = retryExecutor.computeDelayBeforeNextRetry(retriesAttempted);
        Assert.assertEquals((Object)expectedDelay, (Object)computedDelay);
    }

    private void mockMaxRandom() {
        Mockito.when((Object)this.mockRandom.nextInt(ArgumentMatchers.anyInt())).then(invocationOnMock -> {
            Integer firstArg = (Integer)AdditionalAnswers.returnsFirstArg().answer(invocationOnMock);
            return firstArg - 1;
        });
    }

    private void mockMinRandom() {
        Mockito.when((Object)this.mockRandom.nextInt(ArgumentMatchers.anyInt())).then(invocationOnMock -> 0);
    }

    private void mockMediumRandom() {
        Mockito.when((Object)this.mockRandom.nextInt(ArgumentMatchers.anyInt())).then(invocationOnMock -> {
            Integer firstArg = (Integer)AdditionalAnswers.returnsFirstArg().answer(invocationOnMock);
            return firstArg / 2 - 1;
        });
    }

    private static class TestCase {
        private RetryExecutor retryExecutor;
        private int retriesAttempted;
        private Duration expectedMinDelay;
        private Duration expectedMedDelay;
        private Duration expectedMaxDelay;

        private TestCase() {
        }

        public TestCase retryExecutor(RetryExecutor retryExecutor) {
            this.retryExecutor = retryExecutor;
            return this;
        }

        public TestCase retriesAttempted(int retriesAttempted) {
            this.retriesAttempted = retriesAttempted;
            return this;
        }

        public TestCase expectedMinDelay(Duration expectedMinDelay) {
            this.expectedMinDelay = expectedMinDelay;
            return this;
        }

        public TestCase expectedMedDelay(Duration expectedMedDelay) {
            this.expectedMedDelay = expectedMedDelay;
            return this;
        }

        public TestCase expectedMaxDelay(Duration expectedMaxDelay) {
            this.expectedMaxDelay = expectedMaxDelay;
            return this;
        }
    }
}

