/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.FakeTicker;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.config.ConfigException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachedSchemaRegistryClientTest {
    private static final int CACHE_CAPACITY = 5;
    private static final String SCHEMA_STR_0 = CachedSchemaRegistryClientTest.avroSchemaString(0);
    private static final AvroSchema AVRO_SCHEMA_0 = CachedSchemaRegistryClientTest.avroSchema(0);
    private static final AvroSchema SCHEMA_WITH_DECIMAL = new AvroSchema("{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"scale\": 4,\n                    \"precision\": 17,\n                    \"logicalType\": \"decimal\"\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}");
    private static final AvroSchema SCHEMA_WITH_DECIMAL2 = new AvroSchema("{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"logicalType\": \"decimal\",\n                    \"precision\": 17,\n                    \"scale\": 4\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}");
    private static final String SUBJECT_0 = "foo";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int ID_25 = 25;
    private static final int ID_50 = 50;
    private static final Schema SCHEMA_DETAILS = new Schema("foo", Integer.valueOf(7), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0);
    private RestService restService;
    private CachedSchemaRegistryClient client;

    @Before
    public void setUp() {
        this.restService = (RestService)EasyMock.createNiceMock(RestService.class);
        this.client = new CachedSchemaRegistryClient(this.restService, 5, new HashMap());
    }

    @Test
    public void testHttpHeaderConfiguration() {
        Map<String, String> headers = Collections.singletonMap("Authorization", "Bearer RGFuIGlzIGEgZG93bmVy");
        this.restService.setHttpHeaders((Map)EasyMock.eq(headers));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.restService});
        new CachedSchemaRegistryClient(this.restService, 5, null, headers);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDuplicateClientNamespaceConfiguration() {
        Map<String, String> configs = Collections.singletonMap("key", "value");
        this.restService.configure(configs);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.restService});
        HashMap<String, String> duplicateConfigs = new HashMap<String, String>();
        duplicateConfigs.put("key", "value");
        duplicateConfigs.put("schema.registry.key", "value");
        new CachedSchemaRegistryClient(this.restService, 5, duplicateConfigs, null);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterSchemaCacheWithVersionAndId() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0, 1, 25));
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0, 1, 25));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterEquivalentSchemaDifferentid() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(50)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)SCHEMA_WITH_DECIMAL, 1, 25));
        Assert.assertEquals((long)50L, (long)this.client.register(SUBJECT_0, (ParsedSchema)SCHEMA_WITH_DECIMAL2, 2, 50));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterOverCapacity() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), EasyMock.anyString(), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).andReturn((Object)new RegisterSchemaResponse(26)).andReturn((Object)new RegisterSchemaResponse(27)).andReturn((Object)new RegisterSchemaResponse(28)).andReturn((Object)new RegisterSchemaResponse(29)).andReturn((Object)new RegisterSchemaResponse(30));
        EasyMock.replay((Object[])new Object[]{this.restService});
        for (int i = 0; i != 5; ++i) {
            this.client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(i));
        }
        this.client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(5));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andReturn((Object)new SchemaString(SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(SUBJECT_0, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(SUBJECT_0, 25)).rawSchema());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)this.client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)this.client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdenticalSchemas() throws Exception {
        SchemaString schemaStringOne = new SchemaString(SCHEMA_STR_0);
        SchemaString schemaStringTwo = new SchemaString(SCHEMA_STR_0);
        String subjectOne = "subjectOne";
        String subjectTwo = "subjectTwo";
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectOne), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectTwo), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.getId(25, subjectOne)).andReturn((Object)schemaStringOne);
        EasyMock.expect((Object)this.restService.getId(25, subjectTwo)).andReturn((Object)schemaStringTwo);
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(subjectOne, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)this.client.register(subjectTwo, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(subjectOne, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(subjectTwo, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(subjectOne, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(subjectTwo, 25)).rawSchema());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testLookUpEmptyRuleSetMetadataSchema() throws Exception {
        Metadata emptyMetadata = new Metadata(new HashMap(), new HashMap(), Collections.emptySet());
        RuleSet emptyRuleset = new RuleSet(Collections.emptyList(), Collections.emptyList());
        AvroSchema schemaWithEmptyFields = new AvroSchema(AVRO_SCHEMA_0.canonicalString(), new ArrayList(), new HashMap(), emptyMetadata, emptyRuleset, Integer.valueOf(1), true);
        String subjectOne = "subjectOne";
        Schema emptySchemaDetails = new Schema(SUBJECT_0, Integer.valueOf(1), Integer.valueOf(25), "AVRO", Collections.emptyList(), schemaWithEmptyFields.canonicalString());
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectOne), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectOne), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn((Object)emptySchemaDetails);
        EasyMock.expect((Object)this.restService.getId(25, subjectOne)).andReturn((Object)new SchemaString(schemaWithEmptyFields.canonicalString()));
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(subjectOne, (ParsedSchema)schemaWithEmptyFields));
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)this.client.getSchemaBySubjectAndId(subjectOne, 25)).rawSchema());
        Assert.assertEquals((long)25L, (long)this.client.getId(subjectOne, (ParsedSchema)schemaWithEmptyFields, false));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.expect((Object)this.restService.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, false)).andReturn(Arrays.asList(0));
        EasyMock.expect((Object)this.restService.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, true)).andReturn(Arrays.asList(1));
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals(Arrays.asList(0), (Object)this.client.deleteSubject(SUBJECT_0));
        Assert.assertEquals(Arrays.asList(1), (Object)this.client.deleteSubject(SUBJECT_0, true));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, String.valueOf(version), false)).andReturn((Object)0);
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, String.valueOf(version), true)).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)this.client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)this.client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)0, (Object)this.client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version)));
        Assert.assertEquals((Object)1, (Object)this.client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version), true));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testSetMode() throws Exception {
        String mode = "READONLY";
        EasyMock.reset((Object[])new Object[]{this.restService});
        ModeUpdateRequest modeUpdateRequest = new ModeUpdateRequest();
        modeUpdateRequest.setMode("READONLY");
        EasyMock.expect((Object)this.restService.setMode((String)EasyMock.eq((Object)"READONLY"))).andReturn((Object)modeUpdateRequest);
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((Object)"READONLY", (Object)this.client.setMode("READONLY"));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testGetMode() throws Exception {
        String mode = "READONLY";
        EasyMock.reset((Object[])new Object[]{this.restService});
        Mode modeGetResponse = new Mode("READONLY");
        EasyMock.expect((Object)this.restService.getMode()).andReturn((Object)modeGetResponse);
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((Object)"READONLY", (Object)this.client.getMode());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    public void testDeleteVersionNotInVersionCache() throws Exception {
        EasyMock.expect((Object)this.client.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0")).andReturn((Object)10);
        EasyMock.replay((Object[])new Object[]{this.restService});
        Integer result = this.client.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0");
        Assert.assertEquals((Object)10, (Object)result);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteNullSubjectThrows() throws Exception {
        this.client.deleteSubject(null);
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteNullSubjectThrowsPermanent() throws Exception {
        this.client.deleteSubject(null, true);
    }

    @Test
    public void testThreadSafe() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).anyTimes();
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andReturn((Object)new SchemaString(SCHEMA_STR_0)).anyTimes();
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn((Object)SCHEMA_DETAILS).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.restService});
        IntStream.range(0, 1000).parallel().forEach(idx -> {
            try {
                int id = this.client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                int version = this.client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                this.client.getBySubjectAndId(SUBJECT_0, id);
                this.client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version));
                this.client.deleteSubject(SUBJECT_0);
            }
            catch (RestClientException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test(expected=ConfigException.class)
    public void testMultipleCredentialProvider() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("basic.auth.credentials.source", "URL");
        config.put("bearer.auth.credentials.source", "STATIC_TOKEN");
        config.put("bearer.auth.token", "auth-token");
        new CachedSchemaRegistryClient(new RestService("http://user:password@sr.com:8020"), 5, config, null);
    }

    @Test
    public void testGetSchemas() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), EasyMock.anyString(), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).andReturn((Object)new RegisterSchemaResponse(26)).andReturn((Object)new RegisterSchemaResponse(27)).andReturn((Object)new RegisterSchemaResponse(28)).andReturn((Object)new RegisterSchemaResponse(29));
        List schemas = IntStream.range(0, 5).mapToObj(idx -> new Schema(SUBJECT_0, Integer.valueOf(7), Integer.valueOf(idx + 25), "AVRO", Collections.emptyList(), CachedSchemaRegistryClientTest.avroSchemaString(idx))).collect(Collectors.toList());
        EasyMock.expect((Object)this.restService.getSchemas(EasyMock.anyString(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn(schemas);
        EasyMock.replay((Object[])new Object[]{this.restService});
        for (int i = 0; i != 5; ++i) {
            this.client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(i));
        }
        List parsedSchemas = this.client.getSchemas(SUBJECT_0, false, true);
        Assert.assertEquals((long)5L, (long)parsedSchemas.size());
        IntStream.range(0, 5).forEach(idx -> {
            Assert.assertEquals((Object)new AvroSchema(CachedSchemaRegistryClientTest.avroSchemaString(idx)), parsedSchemas.get(idx));
            Assert.assertEquals((Object)"AVRO", (Object)((ParsedSchema)parsedSchemas.get(idx)).schemaType());
        });
    }

    @Test
    public void testGetSchemasEmptyReturn() throws Exception {
        List emptyList = Collections.emptyList();
        EasyMock.expect((Object)this.restService.getSchemas(EasyMock.anyString(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn(emptyList);
        EasyMock.replay((Object[])new Object[]{this.restService});
        List parsedSchemas = this.client.getSchemas(SUBJECT_0, false, true);
        Assert.assertEquals((long)0L, (long)parsedSchemas.size());
    }

    @Test
    public void testLatestVersionCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("latest.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        EasyMock.expect((Object)this.restService.getLatestVersion((String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(1), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(1), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        SchemaMetadata schemaMetadata = this.client.getLatestSchemaMetadata(SUBJECT_0);
        Assert.assertEquals((long)25L, (long)schemaMetadata.getId());
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        schemaMetadata = this.client.getLatestSchemaMetadata(SUBJECT_0);
        Assert.assertEquals((long)25L, (long)schemaMetadata.getId());
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.client.getLatestSchemaMetadata(SUBJECT_0));
    }

    @Test
    public void testLatestWithMetadataCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("latest.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        EasyMock.expect((Object)this.restService.getLatestWithMetadata((String)EasyMock.eq((Object)SUBJECT_0), (Map)EasyMock.anyObject(), EasyMock.eq((boolean)false))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(1), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(1), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        ImmutableMap metadata = ImmutableMap.of((Object)"key", (Object)"value");
        SchemaMetadata schemaMetadata = this.client.getLatestWithMetadata(SUBJECT_0, (Map)metadata, false);
        Assert.assertEquals((long)25L, (long)schemaMetadata.getId());
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        schemaMetadata = this.client.getLatestWithMetadata(SUBJECT_0, (Map)metadata, false);
        Assert.assertEquals((long)25L, (long)schemaMetadata.getId());
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.client.getLatestWithMetadata(SUBJECT_0, (Map)metadata, false));
    }

    @Test
    public void testMissingIdCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andThrow((Throwable)new RestClientException("Schema 25 not found", 404, 40403)).andReturn((Object)new SchemaString(SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            this.client.getSchemaBySubjectAndId(SUBJECT_0, 25);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema 25 not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            this.client.getSchemaBySubjectAndId(SUBJECT_0, 25);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema 25 not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.client.getSchemaBySubjectAndId(SUBJECT_0, 25));
    }

    @Test
    public void testMissingSubjectCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        int version = 7;
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)false))).andThrow((Throwable)new RestClientException("Subject not found", 404, 40401)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Subject not found; error code: 40401", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
    }

    @Test
    public void testMissingSchemaCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        int version = 7;
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)false))).andThrow((Throwable)new RestClientException("Schema not found", 404, 40403)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        this.client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
    }

    private static AvroSchema avroSchema(int i) {
        return new AvroSchema(CachedSchemaRegistryClientTest.avroSchemaString(i));
    }

    private static String avroSchemaString(int i) {
        return "{\"type\": \"record\", \"name\": \"Blah" + i + "\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" }]}";
    }
}

