/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AvroSchemaProviderTest {
    @Test
    public void testResolveRecursiveReferences() throws RestClientException, IOException {
        AvroSchemaProvider avroSchemaProvider = new AvroSchemaProvider();
        MockSchemaRegistryClient mockSchemaRegistryClient = new MockSchemaRegistryClient();
        avroSchemaProvider.configure(Collections.singletonMap("schemaVersionFetcher", mockSchemaRegistryClient));
        String schemaTest1Str = "{ \"type\": \"record\", \"name\": \"test1\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        String schemaTest2Str = "{ \"type\": \"record\", \"name\": \"test2\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        String schemaTest3Str = "{ \"type\": \"record\", \"name\": \"test3\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        List<SchemaReference> referencesForTest1 = Arrays.asList(new SchemaReference("test2", "test2", Integer.valueOf(-1)));
        List<SchemaReference> referencesForTest3 = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(-1)), new SchemaReference("test2", "test2", Integer.valueOf(-1)));
        Schema schemaTest1 = new Schema("test1", Integer.valueOf(1), Integer.valueOf(1001), "AVRO", referencesForTest1, schemaTest1Str);
        Schema schemaTest3 = new Schema("test3", Integer.valueOf(1), Integer.valueOf(1001), "AVRO", referencesForTest3, schemaTest3Str);
        mockSchemaRegistryClient.register("test2", (ParsedSchema)new AvroSchema(schemaTest2Str));
        mockSchemaRegistryClient.register("test1", (ParsedSchema)new AvroSchema(schemaTest1Str, referencesForTest1, avroSchemaProvider.resolveReferences(schemaTest1), null));
        mockSchemaRegistryClient.register("test3", (ParsedSchema)new AvroSchema(schemaTest3Str, referencesForTest3, avroSchemaProvider.resolveReferences(schemaTest3), null));
        List<SchemaReference> referencesForTest1Resolved = Arrays.asList(new SchemaReference("test2", "test2", Integer.valueOf(1)));
        List<SchemaReference> referencesForTest3Resolved = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(1)), new SchemaReference("test2", "test2", Integer.valueOf(1)));
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test1", 1, true).getReferences(), referencesForTest1Resolved);
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test3", 1, true).getReferences(), referencesForTest3Resolved);
    }

    @Test
    public void testResolveRecursiveCircularReferences() throws RestClientException, IOException {
        AvroSchemaProvider avroSchemaProvider = new AvroSchemaProvider();
        MockSchemaRegistryClient mockSchemaRegistryClient = new MockSchemaRegistryClient();
        avroSchemaProvider.configure(Collections.singletonMap("schemaVersionFetcher", mockSchemaRegistryClient));
        String schemaTest1Str = "{ \"type\": \"record\", \"name\": \"test1\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        String schemaTest2Str = "{ \"type\": \"record\", \"name\": \"test2\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        String schemaTest3Str = "{ \"type\": \"record\", \"name\": \"test3\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        List<SchemaReference> referencesForTest1 = Arrays.asList(new SchemaReference("test2", "test2", Integer.valueOf(-1)));
        List<SchemaReference> referencesForTest2 = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(-1)));
        List<SchemaReference> referencesForTest3 = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(-1)), new SchemaReference("test2", "test2", Integer.valueOf(-1)));
        Schema schemaTest1 = new Schema("test1", Integer.valueOf(1), Integer.valueOf(1001), "AVRO", referencesForTest1, schemaTest1Str);
        Schema schemaTest2 = new Schema("test2", Integer.valueOf(1), Integer.valueOf(1001), "AVRO", referencesForTest2, schemaTest2Str);
        Schema schemaTest3 = new Schema("test3", Integer.valueOf(1), Integer.valueOf(1001), "AVRO", referencesForTest3, schemaTest3Str);
        mockSchemaRegistryClient.register("test2", (ParsedSchema)new AvroSchema(schemaTest2Str));
        mockSchemaRegistryClient.register("test1", (ParsedSchema)new AvroSchema(schemaTest1Str, referencesForTest1, avroSchemaProvider.resolveReferences(schemaTest1), null));
        mockSchemaRegistryClient.register("test3", (ParsedSchema)new AvroSchema(schemaTest3Str, referencesForTest3, avroSchemaProvider.resolveReferences(schemaTest3), null));
        schemaTest2Str = "{ \"type\": \"record\", \"name\": \"test2U\", \"fields\": [ { \"type\": \"string\", \"name\": \"field1\" }, { \"type\": \"int\", \"name\": \"field2\" }]}";
        mockSchemaRegistryClient.register("test2", (ParsedSchema)new AvroSchema(schemaTest2Str, referencesForTest2, avroSchemaProvider.resolveReferences(schemaTest2), null));
        List<SchemaReference> referencesForTest1Resolved = Arrays.asList(new SchemaReference("test2", "test2", Integer.valueOf(1)));
        List<SchemaReference> referencesForTest2Resolved = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(1)));
        List<SchemaReference> referencesForTest3Resolved = Arrays.asList(new SchemaReference("test1", "test1", Integer.valueOf(1)), new SchemaReference("test2", "test2", Integer.valueOf(1)));
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test1", 1, true).getReferences(), referencesForTest1Resolved);
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test3", 1, true).getReferences(), referencesForTest3Resolved);
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test2", 1, true).getReferences(), Arrays.asList(new Object[0]));
        Assert.assertEquals((Object)mockSchemaRegistryClient.getByVersion("test2", 2, true).getReferences(), referencesForTest2Resolved);
    }
}

