/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = new HashMap<String, String>();
    private static final Logger log;
    private static final TypeReference<RegisterSchemaResponse> REGISTER_RESPONSE_TYPE;
    private static final TypeReference<Config> GET_CONFIG_RESPONSE_TYPE;
    private static final TypeReference<SchemaString> GET_SCHEMA_BY_ID_RESPONSE_TYPE;
    private static final TypeReference<Schema> GET_SCHEMA_BY_VERSION_RESPONSE_TYPE;
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE;
    private static final TypeReference<List<String>> ALL_TOPICS_RESPONSE_TYPE;
    private static final TypeReference<CompatibilityCheckResponse> COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE;
    private static final TypeReference<Schema> SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE;
    private static final TypeReference<ConfigUpdateRequest> UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE;
    private static ObjectMapper jsonDeserializer;

    public static <T> T httpRequest(String baseUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        log.debug(String.format("Sending %s with input %s to %s", method, requestBodyData == null ? "null" : new String(requestBodyData), baseUrl));
        HttpURLConnection connection = null;
        try {
            InputStream is;
            int responseCode;
            URL url = new URL(baseUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(requestBodyData);
                os.flush();
                os.close();
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            InputStream es = connection.getErrorStream();
            ErrorMessage errorMessage = (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class);
            es.close();
            throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static Schema lookUpSubjectVersion(String baseUrl, Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String url = String.format("%s/subjects/%s", baseUrl, subject);
        Schema response = RestUtils.httpRequest(url, "POST", registerSchemaRequest.toJson().getBytes(), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public static int registerSchema(String baseUrl, Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String url = String.format("%s/subjects/%s/versions", baseUrl, subject);
        RegisterSchemaResponse response = RestUtils.httpRequest(url, "POST", registerSchemaRequest.toJson().getBytes(), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getId();
    }

    public static boolean testCompatibility(String baseUrl, Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        String url = String.format("%s/compatibility/subjects/%s/versions/%s", baseUrl, subject, version);
        CompatibilityCheckResponse response = RestUtils.httpRequest(url, "POST", registerSchemaRequest.toJson().getBytes(), requestProperties, COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE);
        return response.getIsCompatible();
    }

    public static ConfigUpdateRequest updateConfig(String baseUrl, Map<String, String> requestProperties, ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        String url = subject != null ? String.format("%s/config/%s", baseUrl, subject) : String.format("%s/config", baseUrl);
        ConfigUpdateRequest response = RestUtils.httpRequest(url, "PUT", configUpdateRequest.toJson().getBytes(), requestProperties, UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public static Config getConfig(String baseUrl, Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String url = subject != null ? String.format("%s/config/%s", baseUrl, subject) : String.format("%s/config", baseUrl);
        Config config = RestUtils.httpRequest(url, "GET", null, requestProperties, GET_CONFIG_RESPONSE_TYPE);
        return config;
    }

    public static SchemaString getId(String baseUrl, Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        String url = String.format("%s/schemas/ids/%d", baseUrl, id);
        SchemaString response = RestUtils.httpRequest(url, "GET", null, requestProperties, GET_SCHEMA_BY_ID_RESPONSE_TYPE);
        return response;
    }

    public static Schema getVersion(String baseUrl, Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        String url = String.format("%s/subjects/%s/versions/%d", baseUrl, subject, version);
        Schema response = RestUtils.httpRequest(url, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public static Schema getLatestVersion(String baseUrl, Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String url = String.format("%s/subjects/%s/versions/latest", baseUrl, subject);
        Schema response = RestUtils.httpRequest(url, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public static List<Integer> getAllVersions(String baseUrl, Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String url = String.format("%s/subjects/%s/versions", baseUrl, subject);
        List<Integer> response = RestUtils.httpRequest(url, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public static List<String> getAllSubjects(String baseUrl, Map<String, String> requestProperties) throws IOException, RestClientException {
        String url = String.format("%s/subjects", baseUrl);
        List<String> response = RestUtils.httpRequest(url, "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    static {
        DEFAULT_REQUEST_PROPERTIES.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        log = LoggerFactory.getLogger(RestUtils.class);
        REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSchemaResponse>(){};
        GET_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
        GET_SCHEMA_BY_ID_RESPONSE_TYPE = new TypeReference<SchemaString>(){};
        GET_SCHEMA_BY_VERSION_RESPONSE_TYPE = new TypeReference<Schema>(){};
        ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
        ALL_TOPICS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
        COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE = new TypeReference<CompatibilityCheckResponse>(){};
        SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE = new TypeReference<Schema>(){};
        UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE = new TypeReference<ConfigUpdateRequest>(){};
        jsonDeserializer = new ObjectMapper();
    }
}

