/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.RestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.avro.Schema;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private final String baseUrl;
    private final int identityMapCapacity;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> schemaCache;
    private final Map<Integer, org.apache.avro.Schema> idCache;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> versionCache;

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity) {
        this.baseUrl = baseUrl;
        this.identityMapCapacity = identityMapCapacity;
        this.schemaCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
        this.idCache = new HashMap<Integer, org.apache.avro.Schema>();
        this.versionCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
    }

    private int registerAndGetId(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        String schemaString = schema.toString();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return RestUtils.registerSchema(this.baseUrl, RestUtils.DEFAULT_REQUEST_PROPERTIES, request, subject);
    }

    private org.apache.avro.Schema getSchemaByIdFromRegistry(int id) throws IOException, RestClientException {
        SchemaString restSchema = RestUtils.getId(this.baseUrl, RestUtils.DEFAULT_REQUEST_PROPERTIES, id);
        return new Schema.Parser().parse(restSchema.getSchemaString());
    }

    private int getVersionFromRegistry(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        String schemaString = schema.toString();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        Schema response = RestUtils.lookUpSubjectVersion(this.baseUrl, RestUtils.DEFAULT_REQUEST_PROPERTIES, request, subject);
        return response.getVersion();
    }

    @Override
    public synchronized int register(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaIdMap;
        if (this.schemaCache.containsKey(subject)) {
            schemaIdMap = this.schemaCache.get(subject);
        } else {
            schemaIdMap = new IdentityHashMap();
            this.schemaCache.put(subject, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            return (Integer)schemaIdMap.get(schema);
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Two many schema objects created for " + subject + "!");
        }
        int id = this.registerAndGetId(subject, schema);
        schemaIdMap.put(schema, id);
        return id;
    }

    @Override
    public synchronized org.apache.avro.Schema getByID(int id) throws IOException, RestClientException {
        if (this.idCache.containsKey(id)) {
            return this.idCache.get(id);
        }
        org.apache.avro.Schema schema = this.getSchemaByIdFromRegistry(id);
        this.idCache.put(id, schema);
        return schema;
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        Schema response = RestUtils.getLatestVersion(this.baseUrl, RestUtils.DEFAULT_REQUEST_PROPERTIES, subject);
        int id = response.getId();
        int version = response.getVersion();
        String schema = response.getSchema();
        return new SchemaMetadata(id, version, schema);
    }

    @Override
    public synchronized int getVersion(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaVersionMap = this.versionCache.containsKey(subject) ? this.versionCache.get(subject) : new IdentityHashMap();
        if (schemaVersionMap.containsKey(schema)) {
            return (Integer)schemaVersionMap.get(schema);
        }
        if (schemaVersionMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Two many schema objects created for " + subject + "!");
        }
        int version = this.getVersionFromRegistry(subject, schema);
        schemaVersionMap.put(schema, version);
        return version;
    }
}

