/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.FieldSchemaDiff;
import java.util.HashMap;
import java.util.HashSet;

public class OneOfDiff {
    static void compare(Context ctx, OneOfElement original, OneOfElement update) {
        HashMap<Integer, Object> originalByTag = new HashMap<Integer, Object>();
        for (Object field : original.getFields()) {
            originalByTag.put(field.getTag(), field);
        }
        HashMap<Integer, FieldElement> updateByTag = new HashMap<Integer, FieldElement>();
        for (FieldElement field : update.getFields()) {
            updateByTag.put(field.getTag(), field);
        }
        HashSet allTags = new HashSet(originalByTag.keySet());
        allTags.addAll(updateByTag.keySet());
        for (Integer tag : allTags) {
            Context.PathScope pathScope = ctx.enterPath(tag.toString());
            try {
                FieldElement originalField = (FieldElement)originalByTag.get(tag);
                FieldElement updateField = (FieldElement)updateByTag.get(tag);
                if (updateField == null) {
                    ctx.addDifference(Difference.Type.ONEOF_FIELD_REMOVED);
                    continue;
                }
                if (originalField == null) {
                    ctx.addDifference(Difference.Type.ONEOF_FIELD_ADDED);
                    continue;
                }
                FieldSchemaDiff.compare(ctx, originalField, updateField);
            }
            finally {
                if (pathScope == null) continue;
                pathScope.close();
            }
        }
    }
}

