/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.FieldDefinition;
import io.confluent.protobuf.MetaProto;
import java.util.List;

public class MessageDefinition {
    private DescriptorProtos.DescriptorProto mMsgType;

    public static Builder newBuilder(String msgTypeName) {
        return new Builder(msgTypeName);
    }

    public String toString() {
        return this.mMsgType.toString();
    }

    DescriptorProtos.DescriptorProto getMessageType() {
        return this.mMsgType;
    }

    private MessageDefinition(DescriptorProtos.DescriptorProto msgType) {
        this.mMsgType = msgType;
    }

    public static class OneofBuilder {
        private Builder mMsgBuilder;
        private int mIdx;

        public OneofBuilder addField(FieldDefinition fd) {
            this.mMsgBuilder.addField(fd);
            return this;
        }

        public Builder msgDefBuilder() {
            return this.mMsgBuilder;
        }

        public int getIdx() {
            return this.mIdx;
        }

        private OneofBuilder(Builder msgBuilder, int oneofIdx) {
            this.mMsgBuilder = msgBuilder;
            this.mIdx = oneofIdx;
        }
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto.Builder mMsgTypeBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        private int mOneofIndex = 0;

        public String getName() {
            return this.mMsgTypeBuilder.getName();
        }

        public Builder addField(Context ctx, String type, String name, int num) {
            return this.addField(FieldDefinition.newBuilder(ctx, name, num, type).build());
        }

        public Builder addField(FieldDefinition fd) {
            this.mMsgTypeBuilder.addField(fd.getFieldType());
            return this;
        }

        public OneofBuilder addOneof(String oneofName) {
            return this.addOneof(oneofName, null);
        }

        public OneofBuilder addOneof(String oneofName, DescriptorProtos.FeatureSet features) {
            DescriptorProtos.OneofOptions.Builder optionsBuilder = DescriptorProtos.OneofOptions.newBuilder();
            if (features != null) {
                optionsBuilder.setFeatures(features);
            }
            this.mMsgTypeBuilder.addOneofDecl(DescriptorProtos.OneofDescriptorProto.newBuilder().setName(oneofName).mergeOptions(optionsBuilder.build()).build());
            return new OneofBuilder(this, this.mOneofIndex++);
        }

        public boolean containsMessage(String name) {
            List messages = this.mMsgTypeBuilder.getNestedTypeList();
            for (DescriptorProtos.DescriptorProto message : messages) {
                if (!message.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mMsgTypeBuilder.addNestedType(msgDef.getMessageType());
            return this;
        }

        public boolean containsEnum(String name) {
            List enums = this.mMsgTypeBuilder.getEnumTypeList();
            for (DescriptorProtos.EnumDescriptorProto enumer : enums) {
                if (!enumer.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mMsgTypeBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public Builder addReservedName(String reservedName) {
            this.mMsgTypeBuilder.addReservedName(reservedName);
            return this;
        }

        public Builder addReservedRange(int start, int end) {
            DescriptorProtos.DescriptorProto.ReservedRange.Builder rangeBuilder = DescriptorProtos.DescriptorProto.ReservedRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            this.mMsgTypeBuilder.addReservedRange(rangeBuilder.build());
            return this;
        }

        public Builder addExtensionRange(int start, int end, List<DescriptorProtos.ExtensionRangeOptions.Declaration> decls, DescriptorProtos.FeatureSet features, DescriptorProtos.ExtensionRangeOptions.VerificationState verification) {
            DescriptorProtos.DescriptorProto.ExtensionRange.Builder rangeBuilder = DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            DescriptorProtos.ExtensionRangeOptions.Builder optionsBuilder = DescriptorProtos.ExtensionRangeOptions.newBuilder();
            for (DescriptorProtos.ExtensionRangeOptions.Declaration decl : decls) {
                optionsBuilder.addDeclaration(decl);
            }
            if (features != null) {
                optionsBuilder.setFeatures(features);
            }
            if (verification != null) {
                optionsBuilder.setVerification(verification);
            }
            rangeBuilder.mergeOptions(optionsBuilder.build());
            this.mMsgTypeBuilder.addExtensionRange(rangeBuilder.build());
            return this;
        }

        public Builder addExtendDefinition(FieldDefinition fd) {
            this.mMsgTypeBuilder.addExtension(fd.getFieldType());
            return this;
        }

        public Builder setNoStandardDescriptorAccessor(boolean noStandardDescriptorAccessor) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setNoStandardDescriptorAccessor(noStandardDescriptorAccessor);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setDeprecated(boolean isDeprecated) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setDeprecated(isDeprecated);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setMapEntry(boolean mapEntry) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setMapEntry(mapEntry);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setFeatures(DescriptorProtos.FeatureSet features) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setFeatures(features);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setMeta(ProtobufSchema.ProtobufMeta meta) {
            MetaProto.Meta m = DynamicSchema.toMeta(meta);
            if (m != null) {
                DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.messageMeta, (Object)m);
                this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public MessageDefinition build() {
            return new MessageDefinition(this.mMsgTypeBuilder.build());
        }

        private Builder(String msgTypeName) {
            this.mMsgTypeBuilder.setName(msgTypeName);
        }
    }
}

