/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JMSPreconditions;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaQueue;
import io.confluent.kafka.jms.KafkaQueueReceiver;
import io.confluent.kafka.jms.KafkaQueueSender;
import io.confluent.kafka.jms.KafkaSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

class KafkaQueueSession
extends KafkaSession
implements QueueSession {
    public KafkaQueueSession(KafkaConnection connection, boolean transacted, int acknowledgeMode) {
        super(connection, transacted, acknowledgeMode);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (null != messageSelector) {
            throw new JMSException("messageSelectors are not implemented.");
        }
        KafkaQueue kafkaQueue = (KafkaQueue)JMSPreconditions.checkDestination((Destination)queue);
        Consumer consumer = this.connection.consumerFactory.create(true);
        KafkaQueueReceiver queueReceiver = new KafkaQueueReceiver(this.connection.jmsClientConfig, (Consumer<byte[], byte[]>)consumer, kafkaQueue, (KafkaSession)this);
        this.connection.registerConsumer(this, queueReceiver);
        return queueReceiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        KafkaQueue kafkaQueue = (KafkaQueue)JMSPreconditions.checkDestination((Destination)queue);
        Producer<byte[], byte[]> producer = this.connection.producerFactory.create();
        KafkaQueueSender queueSender = new KafkaQueueSender(producer, this.clock, kafkaQueue, this.connection);
        this.connection.registerProducer(this, queueSender);
        return queueSender;
    }
}

