/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JMSPreconditions;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaDestination;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.Unsupported;
import java.util.concurrent.Future;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaMessageProducer
implements MessageProducer {
    static final Logger log = LoggerFactory.getLogger(KafkaMessageProducer.class);
    final Time clock;
    boolean disableMessageTimestamp;
    int deliveryMode = 2;
    int priority = 4;
    long timeToLive = 0L;
    KafkaDestination destination;
    final Producer<byte[], byte[]> producer;
    final KafkaConnection connection;

    KafkaMessageProducer(Producer<byte[], byte[]> producer, Time clock, KafkaDestination destination, KafkaConnection connection) {
        this.producer = producer;
        this.connection = connection;
        this.clock = clock;
        this.destination = destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        return false;
    }

    @Unsupported(value="Message ID's are set to the topic/partition offset. This cannot be disabled.")
    public void setDisableMessageID(boolean value) throws JMSException {
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.disableMessageTimestamp = value;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.priority = defaultPriority;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new JMSException("timeToLive must be greater than 0.");
        }
        this.timeToLive = timeToLive;
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public void close() throws JMSException {
        this.producer.close();
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Future result;
        KafkaDestination kafkaDestination = JMSPreconditions.checkDestination(destination);
        KafkaMessage msg = JMSPreconditions.checkMessage(message);
        msg.setJMSDestination(kafkaDestination);
        log.trace("send() - destination = '{}' deliveryMode = {} priority = {} timeToLive = {} message = {}", new Object[]{destination, deliveryMode, priority, timeToLive, message});
        if (timeToLive < 0L) {
            throw new JMSException("timeToLive must be greater than or equal to 0.");
        }
        if (!this.disableMessageTimestamp) {
            long timestamp = this.clock.milliseconds();
            msg.setJMSTimestamp(timestamp);
        } else {
            msg.setJMSTimestamp(0L);
        }
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSExpiration(0L);
        msg.setJMSRedelivered(false);
        ProducerRecord producerRecord = msg.build();
        log.trace("send() - Calling producer.send().");
        try {
            result = this.producer.send(producerRecord);
        }
        catch (Exception ex) {
            JMSException jmsException = new JMSException("Message send operation failed.");
            jmsException.setLinkedException(ex);
            throw jmsException;
        }
        log.trace("send() - Waiting for result.");
        try {
            RecordMetadata metadata = (RecordMetadata)result.get();
            TopicPartition topicPartition = new TopicPartition(metadata.topic(), metadata.partition());
            msg.setJMSMessageID(topicPartition, metadata.offset());
            log.trace("send() - Message sent as {}", (Object)msg.getJMSMessageID());
        }
        catch (Exception ex) {
            JMSException jmsException = new JMSException("Message send operation failed waiting for a response.");
            jmsException.setLinkedException(ex);
            throw jmsException;
        }
    }
}

